<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request References element to retrieve a specific instance(s) of Job Posting and its associated data.
 * @subpackage Structs
 */
class Job_Posting_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for a Job Posting requested.
     * - maxOccurs: unbounded
     * @var \StructType\Job_PostingObjectType[]
     */
    public $Job_Posting_Reference;
    /**
     * Constructor method for Job_Posting_Request_ReferencesType
     * @uses Job_Posting_Request_ReferencesType::setJob_Posting_Reference()
     * @param \StructType\Job_PostingObjectType[] $job_Posting_Reference
     */
    public function __construct(array $job_Posting_Reference = array())
    {
        $this
            ->setJob_Posting_Reference($job_Posting_Reference);
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType[]|null
     */
    public function getJob_Posting_Reference()
    {
        return $this->Job_Posting_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_ReferenceForArrayConstraintsFromSetJob_Posting_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Request_ReferencesTypeJob_Posting_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Request_ReferencesTypeJob_Posting_ReferenceItem instanceof \StructType\Job_PostingObjectType) {
                $invalidValues[] = is_object($job_Posting_Request_ReferencesTypeJob_Posting_ReferenceItem) ? get_class($job_Posting_Request_ReferencesTypeJob_Posting_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Request_ReferencesTypeJob_Posting_ReferenceItem), var_export($job_Posting_Request_ReferencesTypeJob_Posting_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Reference property can only contain items of type \StructType\Job_PostingObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType[] $job_Posting_Reference
     * @return \StructType\Job_Posting_Request_ReferencesType
     */
    public function setJob_Posting_Reference(array $job_Posting_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_ReferenceArrayErrorMessage = self::validateJob_Posting_ReferenceForArrayConstraintsFromSetJob_Posting_Reference($job_Posting_Reference))) {
            throw new \InvalidArgumentException($job_Posting_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Reference = $job_Posting_Reference;
        return $this;
    }
    /**
     * Add item to Job_Posting_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType $item
     * @return \StructType\Job_Posting_Request_ReferencesType
     */
    public function addToJob_Posting_Reference(\StructType\Job_PostingObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_PostingObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Reference property can only contain items of type \StructType\Job_PostingObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Reference[] = $item;
        return $this;
    }
}
