<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Location_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about a Job Posting's primary and additional Locations.
 * @subpackage Structs
 */
class Job_Posting_Location_DataType extends AbstractStructBase
{
    /**
     * The Primary_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Primary Location for the Job Posting.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Primary_Location_Reference;
    /**
     * The External_Name
     * Meta information extracted from the WSDL
     * - documentation: An alternate name for the primary location when the job details display on the Recruiting External Career Sites.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Name;
    /**
     * The Job_Posting_Additional_Location_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Posting_Additional_Location_DataType[]
     */
    public $Job_Posting_Additional_Location_Data;
    /**
     * Constructor method for Job_Posting_Location_DataType
     * @uses Job_Posting_Location_DataType::setPrimary_Location_Reference()
     * @uses Job_Posting_Location_DataType::setExternal_Name()
     * @uses Job_Posting_Location_DataType::setJob_Posting_Additional_Location_Data()
     * @param \StructType\LocationObjectType $primary_Location_Reference
     * @param string $external_Name
     * @param \StructType\Job_Posting_Additional_Location_DataType[] $job_Posting_Additional_Location_Data
     */
    public function __construct(\StructType\LocationObjectType $primary_Location_Reference = null, $external_Name = null, array $job_Posting_Additional_Location_Data = array())
    {
        $this
            ->setPrimary_Location_Reference($primary_Location_Reference)
            ->setExternal_Name($external_Name)
            ->setJob_Posting_Additional_Location_Data($job_Posting_Additional_Location_Data);
    }
    /**
     * Get Primary_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPrimary_Location_Reference()
    {
        return $this->Primary_Location_Reference;
    }
    /**
     * Set Primary_Location_Reference value
     * @param \StructType\LocationObjectType $primary_Location_Reference
     * @return \StructType\Job_Posting_Location_DataType
     */
    public function setPrimary_Location_Reference(\StructType\LocationObjectType $primary_Location_Reference = null)
    {
        $this->Primary_Location_Reference = $primary_Location_Reference;
        return $this;
    }
    /**
     * Get External_Name value
     * @return string|null
     */
    public function getExternal_Name()
    {
        return $this->External_Name;
    }
    /**
     * Set External_Name value
     * @param string $external_Name
     * @return \StructType\Job_Posting_Location_DataType
     */
    public function setExternal_Name($external_Name = null)
    {
        // validation for constraint: string
        if (!is_null($external_Name) && !is_string($external_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Name, true), gettype($external_Name)), __LINE__);
        }
        $this->External_Name = $external_Name;
        return $this;
    }
    /**
     * Get Job_Posting_Additional_Location_Data value
     * @return \StructType\Job_Posting_Additional_Location_DataType[]|null
     */
    public function getJob_Posting_Additional_Location_Data()
    {
        return $this->Job_Posting_Additional_Location_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Additional_Location_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Additional_Location_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_Additional_Location_DataForArrayConstraintsFromSetJob_Posting_Additional_Location_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Location_DataTypeJob_Posting_Additional_Location_DataItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Location_DataTypeJob_Posting_Additional_Location_DataItem instanceof \StructType\Job_Posting_Additional_Location_DataType) {
                $invalidValues[] = is_object($job_Posting_Location_DataTypeJob_Posting_Additional_Location_DataItem) ? get_class($job_Posting_Location_DataTypeJob_Posting_Additional_Location_DataItem) : sprintf('%s(%s)', gettype($job_Posting_Location_DataTypeJob_Posting_Additional_Location_DataItem), var_export($job_Posting_Location_DataTypeJob_Posting_Additional_Location_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Additional_Location_Data property can only contain items of type \StructType\Job_Posting_Additional_Location_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Additional_Location_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Additional_Location_DataType[] $job_Posting_Additional_Location_Data
     * @return \StructType\Job_Posting_Location_DataType
     */
    public function setJob_Posting_Additional_Location_Data(array $job_Posting_Additional_Location_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_Additional_Location_DataArrayErrorMessage = self::validateJob_Posting_Additional_Location_DataForArrayConstraintsFromSetJob_Posting_Additional_Location_Data($job_Posting_Additional_Location_Data))) {
            throw new \InvalidArgumentException($job_Posting_Additional_Location_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Additional_Location_Data = $job_Posting_Additional_Location_Data;
        return $this;
    }
    /**
     * Add item to Job_Posting_Additional_Location_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Additional_Location_DataType $item
     * @return \StructType\Job_Posting_Location_DataType
     */
    public function addToJob_Posting_Additional_Location_Data(\StructType\Job_Posting_Additional_Location_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_Additional_Location_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Additional_Location_Data property can only contain items of type \StructType\Job_Posting_Additional_Location_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Additional_Location_Data[] = $item;
        return $this;
    }
}
