<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Application_Template_Translation_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains language reference, configurable section, and translated values
 * @subpackage Structs
 */
class Job_Application_Template_Translation_DataType extends AbstractStructBase
{
    /**
     * The Job_Application_Template_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for Job Application Template
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Application_Template_ID;
    /**
     * The User_Language_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference ID or WID for translation language
     * @var \StructType\User_LanguageObjectType
     */
    public $User_Language_Reference;
    /**
     * The Translation_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains base and translated values for all configurable sections
     * - minOccurs: 0
     * @var \StructType\Translated_Configurable_Fields_for_Job_Application_TemplateType
     */
    public $Translation_Data;
    /**
     * Constructor method for Job_Application_Template_Translation_DataType
     * @uses Job_Application_Template_Translation_DataType::setJob_Application_Template_ID()
     * @uses Job_Application_Template_Translation_DataType::setUser_Language_Reference()
     * @uses Job_Application_Template_Translation_DataType::setTranslation_Data()
     * @param string $job_Application_Template_ID
     * @param \StructType\User_LanguageObjectType $user_Language_Reference
     * @param \StructType\Translated_Configurable_Fields_for_Job_Application_TemplateType $translation_Data
     */
    public function __construct($job_Application_Template_ID = null, \StructType\User_LanguageObjectType $user_Language_Reference = null, \StructType\Translated_Configurable_Fields_for_Job_Application_TemplateType $translation_Data = null)
    {
        $this
            ->setJob_Application_Template_ID($job_Application_Template_ID)
            ->setUser_Language_Reference($user_Language_Reference)
            ->setTranslation_Data($translation_Data);
    }
    /**
     * Get Job_Application_Template_ID value
     * @return string|null
     */
    public function getJob_Application_Template_ID()
    {
        return $this->Job_Application_Template_ID;
    }
    /**
     * Set Job_Application_Template_ID value
     * @param string $job_Application_Template_ID
     * @return \StructType\Job_Application_Template_Translation_DataType
     */
    public function setJob_Application_Template_ID($job_Application_Template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Application_Template_ID) && !is_string($job_Application_Template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Application_Template_ID, true), gettype($job_Application_Template_ID)), __LINE__);
        }
        $this->Job_Application_Template_ID = $job_Application_Template_ID;
        return $this;
    }
    /**
     * Get User_Language_Reference value
     * @return \StructType\User_LanguageObjectType|null
     */
    public function getUser_Language_Reference()
    {
        return $this->User_Language_Reference;
    }
    /**
     * Set User_Language_Reference value
     * @param \StructType\User_LanguageObjectType $user_Language_Reference
     * @return \StructType\Job_Application_Template_Translation_DataType
     */
    public function setUser_Language_Reference(\StructType\User_LanguageObjectType $user_Language_Reference = null)
    {
        $this->User_Language_Reference = $user_Language_Reference;
        return $this;
    }
    /**
     * Get Translation_Data value
     * @return \StructType\Translated_Configurable_Fields_for_Job_Application_TemplateType|null
     */
    public function getTranslation_Data()
    {
        return $this->Translation_Data;
    }
    /**
     * Set Translation_Data value
     * @param \StructType\Translated_Configurable_Fields_for_Job_Application_TemplateType $translation_Data
     * @return \StructType\Job_Application_Template_Translation_DataType
     */
    public function setTranslation_Data(\StructType\Translated_Configurable_Fields_for_Job_Application_TemplateType $translation_Data = null)
    {
        $this->Translation_Data = $translation_Data;
        return $this;
    }
}
