<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Application_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: File ID for the attachment already in use. | Contains information about the Job Application for Candidate.
 * @subpackage Structs
 */
class Job_Application_DataType extends AbstractStructBase
{
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a specific Job Application instance for the Candidate.
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Job_Applied_To_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the jobs the candidate has applied to.
     * - maxOccurs: unbounded
     * @var \StructType\Candidate_Job_Applied_To_DataType[]
     */
    public $Job_Applied_To_Data;
    /**
     * The Resume_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment WWS Data element
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment_WWS_DataType[]
     */
    public $Resume_Attachment_Data;
    /**
     * The Resume_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the candidate resume (skills, experience, and education).
     * - minOccurs: 0
     * @var \StructType\Candidate_Resume_DataType
     */
    public $Resume_Data;
    /**
     * Constructor method for Job_Application_DataType
     * @uses Job_Application_DataType::setJob_Application_Reference()
     * @uses Job_Application_DataType::setJob_Applied_To_Data()
     * @uses Job_Application_DataType::setResume_Attachment_Data()
     * @uses Job_Application_DataType::setResume_Data()
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Candidate_Job_Applied_To_DataType[] $job_Applied_To_Data
     * @param \StructType\Attachment_WWS_DataType[] $resume_Attachment_Data
     * @param \StructType\Candidate_Resume_DataType $resume_Data
     */
    public function __construct(\StructType\Job_ApplicationObjectType $job_Application_Reference = null, array $job_Applied_To_Data = array(), array $resume_Attachment_Data = array(), \StructType\Candidate_Resume_DataType $resume_Data = null)
    {
        $this
            ->setJob_Application_Reference($job_Application_Reference)
            ->setJob_Applied_To_Data($job_Applied_To_Data)
            ->setResume_Attachment_Data($resume_Attachment_Data)
            ->setResume_Data($resume_Data);
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return $this->Job_Application_Reference;
    }
    /**
     * Set Job_Application_Reference value
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Job_Application_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        $this->Job_Application_Reference = $job_Application_Reference;
        return $this;
    }
    /**
     * Get Job_Applied_To_Data value
     * @return \StructType\Candidate_Job_Applied_To_DataType[]|null
     */
    public function getJob_Applied_To_Data()
    {
        return $this->Job_Applied_To_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Applied_To_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Applied_To_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Applied_To_DataForArrayConstraintsFromSetJob_Applied_To_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Application_DataTypeJob_Applied_To_DataItem) {
            // validation for constraint: itemType
            if (!$job_Application_DataTypeJob_Applied_To_DataItem instanceof \StructType\Candidate_Job_Applied_To_DataType) {
                $invalidValues[] = is_object($job_Application_DataTypeJob_Applied_To_DataItem) ? get_class($job_Application_DataTypeJob_Applied_To_DataItem) : sprintf('%s(%s)', gettype($job_Application_DataTypeJob_Applied_To_DataItem), var_export($job_Application_DataTypeJob_Applied_To_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Applied_To_Data property can only contain items of type \StructType\Candidate_Job_Applied_To_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Applied_To_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Job_Applied_To_DataType[] $job_Applied_To_Data
     * @return \StructType\Job_Application_DataType
     */
    public function setJob_Applied_To_Data(array $job_Applied_To_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Applied_To_DataArrayErrorMessage = self::validateJob_Applied_To_DataForArrayConstraintsFromSetJob_Applied_To_Data($job_Applied_To_Data))) {
            throw new \InvalidArgumentException($job_Applied_To_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Applied_To_Data = $job_Applied_To_Data;
        return $this;
    }
    /**
     * Add item to Job_Applied_To_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Job_Applied_To_DataType $item
     * @return \StructType\Job_Application_DataType
     */
    public function addToJob_Applied_To_Data(\StructType\Candidate_Job_Applied_To_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Job_Applied_To_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Applied_To_Data property can only contain items of type \StructType\Candidate_Job_Applied_To_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Applied_To_Data[] = $item;
        return $this;
    }
    /**
     * Get Resume_Attachment_Data value
     * @return \StructType\Attachment_WWS_DataType[]|null
     */
    public function getResume_Attachment_Data()
    {
        return $this->Resume_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResume_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResume_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResume_Attachment_DataForArrayConstraintsFromSetResume_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Application_DataTypeResume_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$job_Application_DataTypeResume_Attachment_DataItem instanceof \StructType\Attachment_WWS_DataType) {
                $invalidValues[] = is_object($job_Application_DataTypeResume_Attachment_DataItem) ? get_class($job_Application_DataTypeResume_Attachment_DataItem) : sprintf('%s(%s)', gettype($job_Application_DataTypeResume_Attachment_DataItem), var_export($job_Application_DataTypeResume_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resume_Attachment_Data property can only contain items of type \StructType\Attachment_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resume_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment_WWS_DataType[] $resume_Attachment_Data
     * @return \StructType\Job_Application_DataType
     */
    public function setResume_Attachment_Data(array $resume_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resume_Attachment_DataArrayErrorMessage = self::validateResume_Attachment_DataForArrayConstraintsFromSetResume_Attachment_Data($resume_Attachment_Data))) {
            throw new \InvalidArgumentException($resume_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Resume_Attachment_Data = $resume_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Resume_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment_WWS_DataType $item
     * @return \StructType\Job_Application_DataType
     */
    public function addToResume_Attachment_Data(\StructType\Attachment_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resume_Attachment_Data property can only contain items of type \StructType\Attachment_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resume_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Resume_Data value
     * @return \StructType\Candidate_Resume_DataType|null
     */
    public function getResume_Data()
    {
        return $this->Resume_Data;
    }
    /**
     * Set Resume_Data value
     * @param \StructType\Candidate_Resume_DataType $resume_Data
     * @return \StructType\Job_Application_DataType
     */
    public function setResume_Data(\StructType\Candidate_Resume_DataType $resume_Data = null)
    {
        $this->Resume_Data = $resume_Data;
        return $this;
    }
}
