<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Application_Attachment_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about the Job Application the Attachment was added to.
 * @subpackage Structs
 */
class Job_Application_Attachment_ResponseType extends AbstractStructBase
{
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Job Application.
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Job_Application_Attachment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Attachments added to the Job Application.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resume_AttachmentObjectType[]
     */
    public $Job_Application_Attachment_Reference;
    /**
     * The Job_Applications_Updated
     * Meta information extracted from the WSDL
     * - documentation: Additional Job Applications updated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Applications_Updated;
    /**
     * Constructor method for Job_Application_Attachment_ResponseType
     * @uses Job_Application_Attachment_ResponseType::setJob_Application_Reference()
     * @uses Job_Application_Attachment_ResponseType::setJob_Application_Attachment_Reference()
     * @uses Job_Application_Attachment_ResponseType::setJob_Applications_Updated()
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Resume_AttachmentObjectType[] $job_Application_Attachment_Reference
     * @param string $job_Applications_Updated
     */
    public function __construct(\StructType\Job_ApplicationObjectType $job_Application_Reference = null, array $job_Application_Attachment_Reference = array(), $job_Applications_Updated = null)
    {
        $this
            ->setJob_Application_Reference($job_Application_Reference)
            ->setJob_Application_Attachment_Reference($job_Application_Attachment_Reference)
            ->setJob_Applications_Updated($job_Applications_Updated);
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return $this->Job_Application_Reference;
    }
    /**
     * Set Job_Application_Reference value
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Job_Application_Attachment_ResponseType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        $this->Job_Application_Reference = $job_Application_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Attachment_Reference value
     * @return \StructType\Resume_AttachmentObjectType[]|null
     */
    public function getJob_Application_Attachment_Reference()
    {
        return $this->Job_Application_Attachment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Attachment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Attachment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_Attachment_ReferenceForArrayConstraintsFromSetJob_Application_Attachment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Application_Attachment_ResponseTypeJob_Application_Attachment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Application_Attachment_ResponseTypeJob_Application_Attachment_ReferenceItem instanceof \StructType\Resume_AttachmentObjectType) {
                $invalidValues[] = is_object($job_Application_Attachment_ResponseTypeJob_Application_Attachment_ReferenceItem) ? get_class($job_Application_Attachment_ResponseTypeJob_Application_Attachment_ReferenceItem) : sprintf('%s(%s)', gettype($job_Application_Attachment_ResponseTypeJob_Application_Attachment_ReferenceItem), var_export($job_Application_Attachment_ResponseTypeJob_Application_Attachment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Attachment_Reference property can only contain items of type \StructType\Resume_AttachmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Attachment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resume_AttachmentObjectType[] $job_Application_Attachment_Reference
     * @return \StructType\Job_Application_Attachment_ResponseType
     */
    public function setJob_Application_Attachment_Reference(array $job_Application_Attachment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_Attachment_ReferenceArrayErrorMessage = self::validateJob_Application_Attachment_ReferenceForArrayConstraintsFromSetJob_Application_Attachment_Reference($job_Application_Attachment_Reference))) {
            throw new \InvalidArgumentException($job_Application_Attachment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Attachment_Reference = $job_Application_Attachment_Reference;
        return $this;
    }
    /**
     * Add item to Job_Application_Attachment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resume_AttachmentObjectType $item
     * @return \StructType\Job_Application_Attachment_ResponseType
     */
    public function addToJob_Application_Attachment_Reference(\StructType\Resume_AttachmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resume_AttachmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Attachment_Reference property can only contain items of type \StructType\Resume_AttachmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Attachment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Applications_Updated value
     * @return string|null
     */
    public function getJob_Applications_Updated()
    {
        return $this->Job_Applications_Updated;
    }
    /**
     * Set Job_Applications_Updated value
     * @param string $job_Applications_Updated
     * @return \StructType\Job_Application_Attachment_ResponseType
     */
    public function setJob_Applications_Updated($job_Applications_Updated = null)
    {
        // validation for constraint: string
        if (!is_null($job_Applications_Updated) && !is_string($job_Applications_Updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Applications_Updated, true), gettype($job_Applications_Updated)), __LINE__);
        }
        $this->Job_Applications_Updated = $job_Applications_Updated;
        return $this;
    }
}
