<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Application_Attachment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Information about the Job Application to update and Attachment to be added.
 * @subpackage Structs
 */
class Job_Application_Attachment_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains information about the candidate and their photo.
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Job Application.
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Attachment_Data
     * @var \StructType\Attachment_WWS_DataType
     */
    public $Attachment_Data;
    /**
     * Constructor method for Job_Application_Attachment_DataType
     * @uses Job_Application_Attachment_DataType::setJob_Requisition_Reference()
     * @uses Job_Application_Attachment_DataType::setJob_Application_Reference()
     * @uses Job_Application_Attachment_DataType::setAttachment_Data()
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Attachment_WWS_DataType $attachment_Data
     */
    public function __construct(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Attachment_WWS_DataType $attachment_Data = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Job_Application_Attachment_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return $this->Job_Application_Reference;
    }
    /**
     * Set Job_Application_Reference value
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Job_Application_Attachment_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        $this->Job_Application_Reference = $job_Application_Reference;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Attachment_WWS_DataType|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * Set Attachment_Data value
     * @param \StructType\Attachment_WWS_DataType $attachment_Data
     * @return \StructType\Job_Application_Attachment_DataType
     */
    public function setAttachment_Data(\StructType\Attachment_WWS_DataType $attachment_Data = null)
    {
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
}
