<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Feedback_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the interviewer reference and its feedback data.
 * @subpackage Structs
 */
class Interview_Feedback_Details_DataType extends AbstractStructBase
{
    /**
     * The Interviewer_Reference
     * Meta information extracted from the WSDL
     * - documentation: The interviewer on the interview team.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Interviewer_Reference;
    /**
     * The Interview_Feedback_Details
     * Meta information extracted from the WSDL
     * - documentation: Contains the overall rating and comment for the interview feedback.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interview_Feedback_DetailsType[]
     */
    public $Interview_Feedback_Details;
    /**
     * Constructor method for Interview_Feedback_Details_DataType
     * @uses Interview_Feedback_Details_DataType::setInterviewer_Reference()
     * @uses Interview_Feedback_Details_DataType::setInterview_Feedback_Details()
     * @param \StructType\WorkerObjectType $interviewer_Reference
     * @param \StructType\Interview_Feedback_DetailsType[] $interview_Feedback_Details
     */
    public function __construct(\StructType\WorkerObjectType $interviewer_Reference = null, array $interview_Feedback_Details = array())
    {
        $this
            ->setInterviewer_Reference($interviewer_Reference)
            ->setInterview_Feedback_Details($interview_Feedback_Details);
    }
    /**
     * Get Interviewer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getInterviewer_Reference()
    {
        return $this->Interviewer_Reference;
    }
    /**
     * Set Interviewer_Reference value
     * @param \StructType\WorkerObjectType $interviewer_Reference
     * @return \StructType\Interview_Feedback_Details_DataType
     */
    public function setInterviewer_Reference(\StructType\WorkerObjectType $interviewer_Reference = null)
    {
        $this->Interviewer_Reference = $interviewer_Reference;
        return $this;
    }
    /**
     * Get Interview_Feedback_Details value
     * @return \StructType\Interview_Feedback_DetailsType[]|null
     */
    public function getInterview_Feedback_Details()
    {
        return $this->Interview_Feedback_Details;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Feedback_Details method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Feedback_Details method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Feedback_DetailsForArrayConstraintsFromSetInterview_Feedback_Details(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Feedback_Details_DataTypeInterview_Feedback_DetailsItem) {
            // validation for constraint: itemType
            if (!$interview_Feedback_Details_DataTypeInterview_Feedback_DetailsItem instanceof \StructType\Interview_Feedback_DetailsType) {
                $invalidValues[] = is_object($interview_Feedback_Details_DataTypeInterview_Feedback_DetailsItem) ? get_class($interview_Feedback_Details_DataTypeInterview_Feedback_DetailsItem) : sprintf('%s(%s)', gettype($interview_Feedback_Details_DataTypeInterview_Feedback_DetailsItem), var_export($interview_Feedback_Details_DataTypeInterview_Feedback_DetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Feedback_Details property can only contain items of type \StructType\Interview_Feedback_DetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Feedback_Details value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Feedback_DetailsType[] $interview_Feedback_Details
     * @return \StructType\Interview_Feedback_Details_DataType
     */
    public function setInterview_Feedback_Details(array $interview_Feedback_Details = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Feedback_DetailsArrayErrorMessage = self::validateInterview_Feedback_DetailsForArrayConstraintsFromSetInterview_Feedback_Details($interview_Feedback_Details))) {
            throw new \InvalidArgumentException($interview_Feedback_DetailsArrayErrorMessage, __LINE__);
        }
        $this->Interview_Feedback_Details = $interview_Feedback_Details;
        return $this;
    }
    /**
     * Add item to Interview_Feedback_Details value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Feedback_DetailsType $item
     * @return \StructType\Interview_Feedback_Details_DataType
     */
    public function addToInterview_Feedback_Details(\StructType\Interview_Feedback_DetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interview_Feedback_DetailsType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Feedback_Details property can only contain items of type \StructType\Interview_Feedback_DetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Feedback_Details[] = $item;
        return $this;
    }
}
