<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Image_Banner_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for Image Banner Styling component for brand.
 * @subpackage Structs
 */
class Image_Banner_DataType extends AbstractStructBase
{
    /**
     * The Display_Height
     * Meta information extracted from the WSDL
     * - documentation: Pixel height for image banner of brand.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 8
     * @var float
     */
    public $Display_Height;
    /**
     * The Maintain_Proportions
     * Meta information extracted from the WSDL
     * - documentation: Indicates to maintain image aspect ratio for image banner of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Maintain_Proportions;
    /**
     * The Banner_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Element container for image of brand.
     * - minOccurs: 0
     * @var \StructType\Brand_Image_DataType
     */
    public $Banner_Image_Data;
    /**
     * Constructor method for Image_Banner_DataType
     * @uses Image_Banner_DataType::setDisplay_Height()
     * @uses Image_Banner_DataType::setMaintain_Proportions()
     * @uses Image_Banner_DataType::setBanner_Image_Data()
     * @param float $display_Height
     * @param bool $maintain_Proportions
     * @param \StructType\Brand_Image_DataType $banner_Image_Data
     */
    public function __construct($display_Height = null, $maintain_Proportions = null, \StructType\Brand_Image_DataType $banner_Image_Data = null)
    {
        $this
            ->setDisplay_Height($display_Height)
            ->setMaintain_Proportions($maintain_Proportions)
            ->setBanner_Image_Data($banner_Image_Data);
    }
    /**
     * Get Display_Height value
     * @return float|null
     */
    public function getDisplay_Height()
    {
        return $this->Display_Height;
    }
    /**
     * Set Display_Height value
     * @param float $display_Height
     * @return \StructType\Image_Banner_DataType
     */
    public function setDisplay_Height($display_Height = null)
    {
        // validation for constraint: float
        if (!is_null($display_Height) && !(is_float($display_Height) || is_numeric($display_Height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($display_Height, true), gettype($display_Height)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($display_Height) && mb_strlen(mb_substr($display_Height, false !== mb_strpos($display_Height, '.') ? mb_strpos($display_Height, '.') + 1 : mb_strlen($display_Height))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($display_Height, true), mb_strlen(mb_substr($display_Height, mb_strpos($display_Height, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($display_Height) && $display_Height < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($display_Height, true)), __LINE__);
        }
        // validation for constraint: totalDigits(8)
        if (!is_null($display_Height) && mb_strlen(preg_replace('/(\D)/', '', $display_Height)) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 8 digits, "%d" given', var_export($display_Height, true), mb_strlen(preg_replace('/(\D)/', '', $display_Height))), __LINE__);
        }
        $this->Display_Height = $display_Height;
        return $this;
    }
    /**
     * Get Maintain_Proportions value
     * @return bool|null
     */
    public function getMaintain_Proportions()
    {
        return $this->Maintain_Proportions;
    }
    /**
     * Set Maintain_Proportions value
     * @param bool $maintain_Proportions
     * @return \StructType\Image_Banner_DataType
     */
    public function setMaintain_Proportions($maintain_Proportions = null)
    {
        // validation for constraint: boolean
        if (!is_null($maintain_Proportions) && !is_bool($maintain_Proportions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maintain_Proportions, true), gettype($maintain_Proportions)), __LINE__);
        }
        $this->Maintain_Proportions = $maintain_Proportions;
        return $this;
    }
    /**
     * Get Banner_Image_Data value
     * @return \StructType\Brand_Image_DataType|null
     */
    public function getBanner_Image_Data()
    {
        return $this->Banner_Image_Data;
    }
    /**
     * Set Banner_Image_Data value
     * @param \StructType\Brand_Image_DataType $banner_Image_Data
     * @return \StructType\Image_Banner_DataType
     */
    public function setBanner_Image_Data(\StructType\Brand_Image_DataType $banner_Image_Data = null)
    {
        $this->Banner_Image_Data = $banner_Image_Data;
        return $this;
    }
}
