<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Recruiting_Agency_Users_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains request reference, criteria, filter and response group for getting Recruiting Agency User data.
 * @subpackage Structs
 */
class Get_Recruiting_Agency_Users_RequestType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element containing references to specific Recruiting Agency Users.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_User_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - documentation: The "Response_Filter" element contains common WWS information that allows you control the response data that you will be provided including As_Of_Date, As_Of_Entry_Moment, and Page attributes.
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The Response_Group
     * Meta information extracted from the WSDL
     * - documentation: The response group allows for the response data to be tailored to only included elements that the user is looking for. If no response group is provided in the request, then all groups will be returned.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_User_Response_GroupType
     */
    public $Response_Group;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Recruiting_Agency_Users_RequestType
     * @uses Get_Recruiting_Agency_Users_RequestType::setRequest_References()
     * @uses Get_Recruiting_Agency_Users_RequestType::setResponse_Filter()
     * @uses Get_Recruiting_Agency_Users_RequestType::setResponse_Group()
     * @uses Get_Recruiting_Agency_Users_RequestType::setVersion()
     * @param \StructType\Recruiting_Agency_User_Request_ReferencesType $request_References
     * @param \StructType\Response_FilterType $response_Filter
     * @param \StructType\Recruiting_Agency_User_Response_GroupType $response_Group
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Agency_User_Request_ReferencesType $request_References = null, \StructType\Response_FilterType $response_Filter = null, \StructType\Recruiting_Agency_User_Response_GroupType $response_Group = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setResponse_Filter($response_Filter)
            ->setResponse_Group($response_Group)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Recruiting_Agency_User_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Recruiting_Agency_User_Request_ReferencesType $request_References
     * @return \StructType\Get_Recruiting_Agency_Users_RequestType
     */
    public function setRequest_References(\StructType\Recruiting_Agency_User_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Recruiting_Agency_Users_RequestType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get Response_Group value
     * @return \StructType\Recruiting_Agency_User_Response_GroupType|null
     */
    public function getResponse_Group()
    {
        return $this->Response_Group;
    }
    /**
     * Set Response_Group value
     * @param \StructType\Recruiting_Agency_User_Response_GroupType $response_Group
     * @return \StructType\Get_Recruiting_Agency_Users_RequestType
     */
    public function setResponse_Group(\StructType\Recruiting_Agency_User_Response_GroupType $response_Group = null)
    {
        $this->Response_Group = $response_Group;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Recruiting_Agency_Users_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
