<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Background_Check_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: All the data for requesting details for Background Check Events. This web service operation assumes the Background Check Events use Background Check Package.
 * @subpackage Structs
 */
class Get_Background_Check_RequestType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: References to the specific Background Check Events to return.
     * - minOccurs: 0
     * @var \StructType\Background_Check_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Request_Criteria
     * Meta information extracted from the WSDL
     * - documentation: Parameters that let you specify the Background Check Events that are returned.
     * - minOccurs: 0
     * @var \StructType\Background_Check_Request_CriteriaType
     */
    public $Request_Criteria;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Background_Check_RequestType
     * @uses Get_Background_Check_RequestType::setRequest_References()
     * @uses Get_Background_Check_RequestType::setRequest_Criteria()
     * @uses Get_Background_Check_RequestType::setResponse_Filter()
     * @uses Get_Background_Check_RequestType::setVersion()
     * @param \StructType\Background_Check_Request_ReferencesType $request_References
     * @param \StructType\Background_Check_Request_CriteriaType $request_Criteria
     * @param \StructType\Response_FilterType $response_Filter
     * @param string $version
     */
    public function __construct(\StructType\Background_Check_Request_ReferencesType $request_References = null, \StructType\Background_Check_Request_CriteriaType $request_Criteria = null, \StructType\Response_FilterType $response_Filter = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setRequest_Criteria($request_Criteria)
            ->setResponse_Filter($response_Filter)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Background_Check_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Background_Check_Request_ReferencesType $request_References
     * @return \StructType\Get_Background_Check_RequestType
     */
    public function setRequest_References(\StructType\Background_Check_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Request_Criteria value
     * @return \StructType\Background_Check_Request_CriteriaType|null
     */
    public function getRequest_Criteria()
    {
        return $this->Request_Criteria;
    }
    /**
     * Set Request_Criteria value
     * @param \StructType\Background_Check_Request_CriteriaType $request_Criteria
     * @return \StructType\Get_Background_Check_RequestType
     */
    public function setRequest_Criteria(\StructType\Background_Check_Request_CriteriaType $request_Criteria = null)
    {
        $this->Request_Criteria = $request_Criteria;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Background_Check_RequestType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Background_Check_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
