<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Evergreen_Job_Requisition_Data_2Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for an Evergreen Requisition
 * @subpackage Structs
 */
class Evergreen_Job_Requisition_Data_2Type extends AbstractStructBase
{
    /**
     * The Job_Requisition_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status of the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_StatusObjectType
     */
    public $Job_Requisition_Status_Reference;
    /**
     * The Linked_Job_Requisitions_Reference
     * Meta information extracted from the WSDL
     * - documentation: The linked job requisitions for this evergreen requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType[]
     */
    public $Linked_Job_Requisitions_Reference;
    /**
     * The Job_Requisition_Detail_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Definition_DataType
     */
    public $Job_Requisition_Detail_Data;
    /**
     * The Hiring_Requirement_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Restrictions_DataType
     */
    public $Hiring_Requirement_Data;
    /**
     * The Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_AttachmentsType
     */
    public $Job_Requisition_Attachments;
    /**
     * The Qualification_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public $Qualification_Data;
    /**
     * The Questionnaire_Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Questionnaire_DataType
     */
    public $Questionnaire_Reference;
    /**
     * The Assessment_Data
     * Meta information extracted from the WSDL
     * - documentation: Assessments for the Job Requisition. For use by Recruiting customers only.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Assessment_DataType
     */
    public $Assessment_Data;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supervisory Organization for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Integration_Field_Override_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_Field_Result_DataType[]
     */
    public $Integration_Field_Override_Data;
    /**
     * The Organization_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Organizations_DataType[]
     */
    public $Organization_Data;
    /**
     * The Role_Assignment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Role_Assignment_Effective_DataType[]
     */
    public $Role_Assignment_Data;
    /**
     * The Requisition_Compensation_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_Compensation_DataType[]
     */
    public $Requisition_Compensation_Data;
    /**
     * Constructor method for Evergreen_Job_Requisition_Data_2Type
     * @uses Evergreen_Job_Requisition_Data_2Type::setJob_Requisition_Status_Reference()
     * @uses Evergreen_Job_Requisition_Data_2Type::setLinked_Job_Requisitions_Reference()
     * @uses Evergreen_Job_Requisition_Data_2Type::setJob_Requisition_Detail_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setHiring_Requirement_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setJob_Requisition_Attachments()
     * @uses Evergreen_Job_Requisition_Data_2Type::setQualification_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setQuestionnaire_Reference()
     * @uses Evergreen_Job_Requisition_Data_2Type::setAssessment_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setSupervisory_Organization_Reference()
     * @uses Evergreen_Job_Requisition_Data_2Type::setIntegration_Field_Override_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setOrganization_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setRole_Assignment_Data()
     * @uses Evergreen_Job_Requisition_Data_2Type::setRequisition_Compensation_Data()
     * @param \StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference
     * @param \StructType\Job_RequisitionObjectType[] $linked_Job_Requisitions_Reference
     * @param \StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data
     * @param \StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data
     * @param \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments
     * @param \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data
     * @param \StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Reference
     * @param \StructType\Job_Requisition_Assessment_DataType $assessment_Data
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\Document_Field_Result_DataType[] $integration_Field_Override_Data
     * @param \StructType\Job_Requisition_Organizations_DataType[] $organization_Data
     * @param \StructType\Role_Assignment_Effective_DataType[] $role_Assignment_Data
     * @param \StructType\Requisition_Compensation_DataType[] $requisition_Compensation_Data
     */
    public function __construct(\StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference = null, array $linked_Job_Requisitions_Reference = array(), \StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data = null, \StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data = null, \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments = null, \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data = null, \StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Reference = null, \StructType\Job_Requisition_Assessment_DataType $assessment_Data = null, \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, array $integration_Field_Override_Data = array(), array $organization_Data = array(), array $role_Assignment_Data = array(), array $requisition_Compensation_Data = array())
    {
        $this
            ->setJob_Requisition_Status_Reference($job_Requisition_Status_Reference)
            ->setLinked_Job_Requisitions_Reference($linked_Job_Requisitions_Reference)
            ->setJob_Requisition_Detail_Data($job_Requisition_Detail_Data)
            ->setHiring_Requirement_Data($hiring_Requirement_Data)
            ->setJob_Requisition_Attachments($job_Requisition_Attachments)
            ->setQualification_Data($qualification_Data)
            ->setQuestionnaire_Reference($questionnaire_Reference)
            ->setAssessment_Data($assessment_Data)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setIntegration_Field_Override_Data($integration_Field_Override_Data)
            ->setOrganization_Data($organization_Data)
            ->setRole_Assignment_Data($role_Assignment_Data)
            ->setRequisition_Compensation_Data($requisition_Compensation_Data);
    }
    /**
     * Get Job_Requisition_Status_Reference value
     * @return \StructType\Job_Requisition_StatusObjectType|null
     */
    public function getJob_Requisition_Status_Reference()
    {
        return $this->Job_Requisition_Status_Reference;
    }
    /**
     * Set Job_Requisition_Status_Reference value
     * @param \StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setJob_Requisition_Status_Reference(\StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference = null)
    {
        $this->Job_Requisition_Status_Reference = $job_Requisition_Status_Reference;
        return $this;
    }
    /**
     * Get Linked_Job_Requisitions_Reference value
     * @return \StructType\Job_RequisitionObjectType[]|null
     */
    public function getLinked_Job_Requisitions_Reference()
    {
        return $this->Linked_Job_Requisitions_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLinked_Job_Requisitions_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinked_Job_Requisitions_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinked_Job_Requisitions_ReferenceForArrayConstraintsFromSetLinked_Job_Requisitions_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_2TypeLinked_Job_Requisitions_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_2TypeLinked_Job_Requisitions_ReferenceItem instanceof \StructType\Job_RequisitionObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_2TypeLinked_Job_Requisitions_ReferenceItem) ? get_class($evergreen_Job_Requisition_Data_2TypeLinked_Job_Requisitions_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_2TypeLinked_Job_Requisitions_ReferenceItem), var_export($evergreen_Job_Requisition_Data_2TypeLinked_Job_Requisitions_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Linked_Job_Requisitions_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Linked_Job_Requisitions_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType[] $linked_Job_Requisitions_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setLinked_Job_Requisitions_Reference(array $linked_Job_Requisitions_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($linked_Job_Requisitions_ReferenceArrayErrorMessage = self::validateLinked_Job_Requisitions_ReferenceForArrayConstraintsFromSetLinked_Job_Requisitions_Reference($linked_Job_Requisitions_Reference))) {
            throw new \InvalidArgumentException($linked_Job_Requisitions_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Linked_Job_Requisitions_Reference = $linked_Job_Requisitions_Reference;
        return $this;
    }
    /**
     * Add item to Linked_Job_Requisitions_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function addToLinked_Job_Requisitions_Reference(\StructType\Job_RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Linked_Job_Requisitions_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Linked_Job_Requisitions_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Detail_Data value
     * @return \StructType\Job_Requisition_Definition_DataType|null
     */
    public function getJob_Requisition_Detail_Data()
    {
        return $this->Job_Requisition_Detail_Data;
    }
    /**
     * Set Job_Requisition_Detail_Data value
     * @param \StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setJob_Requisition_Detail_Data(\StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data = null)
    {
        $this->Job_Requisition_Detail_Data = $job_Requisition_Detail_Data;
        return $this;
    }
    /**
     * Get Hiring_Requirement_Data value
     * @return \StructType\Job_Requisition_Restrictions_DataType|null
     */
    public function getHiring_Requirement_Data()
    {
        return $this->Hiring_Requirement_Data;
    }
    /**
     * Set Hiring_Requirement_Data value
     * @param \StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setHiring_Requirement_Data(\StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data = null)
    {
        $this->Hiring_Requirement_Data = $hiring_Requirement_Data;
        return $this;
    }
    /**
     * Get Job_Requisition_Attachments value
     * @return \StructType\Job_Requisition_AttachmentsType|null
     */
    public function getJob_Requisition_Attachments()
    {
        return $this->Job_Requisition_Attachments;
    }
    /**
     * Set Job_Requisition_Attachments value
     * @param \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setJob_Requisition_Attachments(\StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments = null)
    {
        $this->Job_Requisition_Attachments = $job_Requisition_Attachments;
        return $this;
    }
    /**
     * Get Qualification_Data value
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType|null
     */
    public function getQualification_Data()
    {
        return $this->Qualification_Data;
    }
    /**
     * Set Qualification_Data value
     * @param \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setQualification_Data(\StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data = null)
    {
        $this->Qualification_Data = $qualification_Data;
        return $this;
    }
    /**
     * Get Questionnaire_Reference value
     * @return \StructType\Job_Requisition_Questionnaire_DataType|null
     */
    public function getQuestionnaire_Reference()
    {
        return $this->Questionnaire_Reference;
    }
    /**
     * Set Questionnaire_Reference value
     * @param \StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setQuestionnaire_Reference(\StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Reference = null)
    {
        $this->Questionnaire_Reference = $questionnaire_Reference;
        return $this;
    }
    /**
     * Get Assessment_Data value
     * @return \StructType\Job_Requisition_Assessment_DataType|null
     */
    public function getAssessment_Data()
    {
        return $this->Assessment_Data;
    }
    /**
     * Set Assessment_Data value
     * @param \StructType\Job_Requisition_Assessment_DataType $assessment_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setAssessment_Data(\StructType\Job_Requisition_Assessment_DataType $assessment_Data = null)
    {
        $this->Assessment_Data = $assessment_Data;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Integration_Field_Override_Data value
     * @return \StructType\Document_Field_Result_DataType[]|null
     */
    public function getIntegration_Field_Override_Data()
    {
        return $this->Integration_Field_Override_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setIntegration_Field_Override_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIntegration_Field_Override_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIntegration_Field_Override_DataForArrayConstraintsFromSetIntegration_Field_Override_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_2TypeIntegration_Field_Override_DataItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_2TypeIntegration_Field_Override_DataItem instanceof \StructType\Document_Field_Result_DataType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_2TypeIntegration_Field_Override_DataItem) ? get_class($evergreen_Job_Requisition_Data_2TypeIntegration_Field_Override_DataItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_2TypeIntegration_Field_Override_DataItem), var_export($evergreen_Job_Requisition_Data_2TypeIntegration_Field_Override_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Integration_Field_Override_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Integration_Field_Override_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType[] $integration_Field_Override_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setIntegration_Field_Override_Data(array $integration_Field_Override_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($integration_Field_Override_DataArrayErrorMessage = self::validateIntegration_Field_Override_DataForArrayConstraintsFromSetIntegration_Field_Override_Data($integration_Field_Override_Data))) {
            throw new \InvalidArgumentException($integration_Field_Override_DataArrayErrorMessage, __LINE__);
        }
        $this->Integration_Field_Override_Data = $integration_Field_Override_Data;
        return $this;
    }
    /**
     * Add item to Integration_Field_Override_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function addToIntegration_Field_Override_Data(\StructType\Document_Field_Result_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_Field_Result_DataType) {
            throw new \InvalidArgumentException(sprintf('The Integration_Field_Override_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Integration_Field_Override_Data[] = $item;
        return $this;
    }
    /**
     * Get Organization_Data value
     * @return \StructType\Job_Requisition_Organizations_DataType[]|null
     */
    public function getOrganization_Data()
    {
        return $this->Organization_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_DataForArrayConstraintsFromSetOrganization_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_2TypeOrganization_DataItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_2TypeOrganization_DataItem instanceof \StructType\Job_Requisition_Organizations_DataType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_2TypeOrganization_DataItem) ? get_class($evergreen_Job_Requisition_Data_2TypeOrganization_DataItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_2TypeOrganization_DataItem), var_export($evergreen_Job_Requisition_Data_2TypeOrganization_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Data property can only contain items of type \StructType\Job_Requisition_Organizations_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Organizations_DataType[] $organization_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setOrganization_Data(array $organization_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_DataArrayErrorMessage = self::validateOrganization_DataForArrayConstraintsFromSetOrganization_Data($organization_Data))) {
            throw new \InvalidArgumentException($organization_DataArrayErrorMessage, __LINE__);
        }
        $this->Organization_Data = $organization_Data;
        return $this;
    }
    /**
     * Add item to Organization_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Organizations_DataType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function addToOrganization_Data(\StructType\Job_Requisition_Organizations_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_Organizations_DataType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Data property can only contain items of type \StructType\Job_Requisition_Organizations_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Data[] = $item;
        return $this;
    }
    /**
     * Get Role_Assignment_Data value
     * @return \StructType\Role_Assignment_Effective_DataType[]|null
     */
    public function getRole_Assignment_Data()
    {
        return $this->Role_Assignment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRole_Assignment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRole_Assignment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRole_Assignment_DataForArrayConstraintsFromSetRole_Assignment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_2TypeRole_Assignment_DataItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_2TypeRole_Assignment_DataItem instanceof \StructType\Role_Assignment_Effective_DataType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_2TypeRole_Assignment_DataItem) ? get_class($evergreen_Job_Requisition_Data_2TypeRole_Assignment_DataItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_2TypeRole_Assignment_DataItem), var_export($evergreen_Job_Requisition_Data_2TypeRole_Assignment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Role_Assignment_Data property can only contain items of type \StructType\Role_Assignment_Effective_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Role_Assignment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Role_Assignment_Effective_DataType[] $role_Assignment_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setRole_Assignment_Data(array $role_Assignment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($role_Assignment_DataArrayErrorMessage = self::validateRole_Assignment_DataForArrayConstraintsFromSetRole_Assignment_Data($role_Assignment_Data))) {
            throw new \InvalidArgumentException($role_Assignment_DataArrayErrorMessage, __LINE__);
        }
        $this->Role_Assignment_Data = $role_Assignment_Data;
        return $this;
    }
    /**
     * Add item to Role_Assignment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Role_Assignment_Effective_DataType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function addToRole_Assignment_Data(\StructType\Role_Assignment_Effective_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Role_Assignment_Effective_DataType) {
            throw new \InvalidArgumentException(sprintf('The Role_Assignment_Data property can only contain items of type \StructType\Role_Assignment_Effective_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Role_Assignment_Data[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Compensation_Data value
     * @return \StructType\Requisition_Compensation_DataType[]|null
     */
    public function getRequisition_Compensation_Data()
    {
        return $this->Requisition_Compensation_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Compensation_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Compensation_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Compensation_DataForArrayConstraintsFromSetRequisition_Compensation_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_2TypeRequisition_Compensation_DataItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_2TypeRequisition_Compensation_DataItem instanceof \StructType\Requisition_Compensation_DataType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_2TypeRequisition_Compensation_DataItem) ? get_class($evergreen_Job_Requisition_Data_2TypeRequisition_Compensation_DataItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_2TypeRequisition_Compensation_DataItem), var_export($evergreen_Job_Requisition_Data_2TypeRequisition_Compensation_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Compensation_Data property can only contain items of type \StructType\Requisition_Compensation_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Compensation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Compensation_DataType[] $requisition_Compensation_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function setRequisition_Compensation_Data(array $requisition_Compensation_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Compensation_DataArrayErrorMessage = self::validateRequisition_Compensation_DataForArrayConstraintsFromSetRequisition_Compensation_Data($requisition_Compensation_Data))) {
            throw new \InvalidArgumentException($requisition_Compensation_DataArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Compensation_Data = $requisition_Compensation_Data;
        return $this;
    }
    /**
     * Add item to Requisition_Compensation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Compensation_DataType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_2Type
     */
    public function addToRequisition_Compensation_Data(\StructType\Requisition_Compensation_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_Compensation_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Compensation_Data property can only contain items of type \StructType\Requisition_Compensation_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Compensation_Data[] = $item;
        return $this;
    }
}
