<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dynamic_Business_Process_ParametersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for the processing options for a dynamic business process. If no options are submitted, the process does not move to the next stage or disposition.
 * @subpackage Structs
 */
class Dynamic_Business_Process_ParametersType extends AbstractStructBase
{
    /**
     * The Next_Step_Reference
     * Meta information extracted from the WSDL
     * - documentation: Sends the dynamic business process to the next specified sub-process. This must be a valid next stage based off the current stage of the dynamic business process and the allowed next steps in its definition.
     * - choice: Next_Step_Reference | Disposition_Step_Reference | Start_Parallel_Stage_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Workflow_StepObjectType
     */
    public $Next_Step_Reference;
    /**
     * The Disposition_Step_Reference
     * Meta information extracted from the WSDL
     * - documentation: The disposition step for the dynamic business process. This must be a valid disposition step for the current stage of the business process according to the business process definition.
     * - choice: Next_Step_Reference | Disposition_Step_Reference | Start_Parallel_Stage_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Workflow_StepObjectType
     */
    public $Disposition_Step_Reference;
    /**
     * The Start_Parallel_Stage_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Parallel Workflow Step to initiate for the Job Application
     * - choice: Next_Step_Reference | Disposition_Step_Reference | Start_Parallel_Stage_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Workflow_StepObjectType
     */
    public $Start_Parallel_Stage_Reference;
    /**
     * The Comment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Process_Comment_DataType[]
     */
    public $Comment_Data;
    /**
     * Constructor method for Dynamic_Business_Process_ParametersType
     * @uses Dynamic_Business_Process_ParametersType::setNext_Step_Reference()
     * @uses Dynamic_Business_Process_ParametersType::setDisposition_Step_Reference()
     * @uses Dynamic_Business_Process_ParametersType::setStart_Parallel_Stage_Reference()
     * @uses Dynamic_Business_Process_ParametersType::setComment_Data()
     * @param \StructType\Workflow_StepObjectType $next_Step_Reference
     * @param \StructType\Workflow_StepObjectType $disposition_Step_Reference
     * @param \StructType\Workflow_StepObjectType $start_Parallel_Stage_Reference
     * @param \StructType\Business_Process_Comment_DataType[] $comment_Data
     */
    public function __construct(\StructType\Workflow_StepObjectType $next_Step_Reference = null, \StructType\Workflow_StepObjectType $disposition_Step_Reference = null, \StructType\Workflow_StepObjectType $start_Parallel_Stage_Reference = null, array $comment_Data = array())
    {
        $this
            ->setNext_Step_Reference($next_Step_Reference)
            ->setDisposition_Step_Reference($disposition_Step_Reference)
            ->setStart_Parallel_Stage_Reference($start_Parallel_Stage_Reference)
            ->setComment_Data($comment_Data);
    }
    /**
     * Get Next_Step_Reference value
     * @return \StructType\Workflow_StepObjectType|null
     */
    public function getNext_Step_Reference()
    {
        return isset($this->Next_Step_Reference) ? $this->Next_Step_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNext_Step_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNext_Step_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNext_Step_ReferenceForChoiceConstraintsFromSetNext_Step_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Disposition_Step_Reference',
            'Start_Parallel_Stage_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Next_Step_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Next_Step_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Next_Step_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Workflow_StepObjectType $next_Step_Reference
     * @return \StructType\Dynamic_Business_Process_ParametersType
     */
    public function setNext_Step_Reference(\StructType\Workflow_StepObjectType $next_Step_Reference = null)
    {
        // validation for constraint: choice(Next_Step_Reference, Disposition_Step_Reference, Start_Parallel_Stage_Reference)
        if ('' !== ($next_Step_ReferenceChoiceErrorMessage = self::validateNext_Step_ReferenceForChoiceConstraintsFromSetNext_Step_Reference($next_Step_Reference))) {
            throw new \InvalidArgumentException($next_Step_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($next_Step_Reference) || (is_array($next_Step_Reference) && empty($next_Step_Reference))) {
            unset($this->Next_Step_Reference);
        } else {
            $this->Next_Step_Reference = $next_Step_Reference;
        }
        return $this;
    }
    /**
     * Get Disposition_Step_Reference value
     * @return \StructType\Workflow_StepObjectType|null
     */
    public function getDisposition_Step_Reference()
    {
        return isset($this->Disposition_Step_Reference) ? $this->Disposition_Step_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDisposition_Step_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisposition_Step_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDisposition_Step_ReferenceForChoiceConstraintsFromSetDisposition_Step_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Next_Step_Reference',
            'Start_Parallel_Stage_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Disposition_Step_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Disposition_Step_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Disposition_Step_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Workflow_StepObjectType $disposition_Step_Reference
     * @return \StructType\Dynamic_Business_Process_ParametersType
     */
    public function setDisposition_Step_Reference(\StructType\Workflow_StepObjectType $disposition_Step_Reference = null)
    {
        // validation for constraint: choice(Next_Step_Reference, Disposition_Step_Reference, Start_Parallel_Stage_Reference)
        if ('' !== ($disposition_Step_ReferenceChoiceErrorMessage = self::validateDisposition_Step_ReferenceForChoiceConstraintsFromSetDisposition_Step_Reference($disposition_Step_Reference))) {
            throw new \InvalidArgumentException($disposition_Step_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($disposition_Step_Reference) || (is_array($disposition_Step_Reference) && empty($disposition_Step_Reference))) {
            unset($this->Disposition_Step_Reference);
        } else {
            $this->Disposition_Step_Reference = $disposition_Step_Reference;
        }
        return $this;
    }
    /**
     * Get Start_Parallel_Stage_Reference value
     * @return \StructType\Workflow_StepObjectType|null
     */
    public function getStart_Parallel_Stage_Reference()
    {
        return isset($this->Start_Parallel_Stage_Reference) ? $this->Start_Parallel_Stage_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStart_Parallel_Stage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart_Parallel_Stage_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStart_Parallel_Stage_ReferenceForChoiceConstraintsFromSetStart_Parallel_Stage_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Next_Step_Reference',
            'Disposition_Step_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Start_Parallel_Stage_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Start_Parallel_Stage_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Start_Parallel_Stage_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Workflow_StepObjectType $start_Parallel_Stage_Reference
     * @return \StructType\Dynamic_Business_Process_ParametersType
     */
    public function setStart_Parallel_Stage_Reference(\StructType\Workflow_StepObjectType $start_Parallel_Stage_Reference = null)
    {
        // validation for constraint: choice(Next_Step_Reference, Disposition_Step_Reference, Start_Parallel_Stage_Reference)
        if ('' !== ($start_Parallel_Stage_ReferenceChoiceErrorMessage = self::validateStart_Parallel_Stage_ReferenceForChoiceConstraintsFromSetStart_Parallel_Stage_Reference($start_Parallel_Stage_Reference))) {
            throw new \InvalidArgumentException($start_Parallel_Stage_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($start_Parallel_Stage_Reference) || (is_array($start_Parallel_Stage_Reference) && empty($start_Parallel_Stage_Reference))) {
            unset($this->Start_Parallel_Stage_Reference);
        } else {
            $this->Start_Parallel_Stage_Reference = $start_Parallel_Stage_Reference;
        }
        return $this;
    }
    /**
     * Get Comment_Data value
     * @return \StructType\Business_Process_Comment_DataType[]|null
     */
    public function getComment_Data()
    {
        return $this->Comment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setComment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComment_DataForArrayConstraintsFromSetComment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dynamic_Business_Process_ParametersTypeComment_DataItem) {
            // validation for constraint: itemType
            if (!$dynamic_Business_Process_ParametersTypeComment_DataItem instanceof \StructType\Business_Process_Comment_DataType) {
                $invalidValues[] = is_object($dynamic_Business_Process_ParametersTypeComment_DataItem) ? get_class($dynamic_Business_Process_ParametersTypeComment_DataItem) : sprintf('%s(%s)', gettype($dynamic_Business_Process_ParametersTypeComment_DataItem), var_export($dynamic_Business_Process_ParametersTypeComment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comment_Data property can only contain items of type \StructType\Business_Process_Comment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Process_Comment_DataType[] $comment_Data
     * @return \StructType\Dynamic_Business_Process_ParametersType
     */
    public function setComment_Data(array $comment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($comment_DataArrayErrorMessage = self::validateComment_DataForArrayConstraintsFromSetComment_Data($comment_Data))) {
            throw new \InvalidArgumentException($comment_DataArrayErrorMessage, __LINE__);
        }
        $this->Comment_Data = $comment_Data;
        return $this;
    }
    /**
     * Add item to Comment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Process_Comment_DataType $item
     * @return \StructType\Dynamic_Business_Process_ParametersType
     */
    public function addToComment_Data(\StructType\Business_Process_Comment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Process_Comment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Comment_Data property can only contain items of type \StructType\Business_Process_Comment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Comment_Data[] = $item;
        return $this;
    }
}
