<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Custom_Organization_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows user to add new or delete existing custom organizations. If a new Unique custom organization is added - the prior org of that type will be deleted. (The old organization does not have to be submitted with delete flag true). If
 * a new non-Unique custom organization is added - the existing org(s) of that type will be retained (unless they are sent with the delete flag true). Custom Organizations that are not being modified do not need to be submitted.In version v24.2 and
 * earlier, the behavior is "replace": existing custom organizations are removed and the new custom organizations will be added.
 * @subpackage Structs
 */
class Custom_Organization_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Custom_Organization_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier for the Custom Organization Assignment. When Delete equals Y, this custom organization assignment will be deleted. When Delete equals Y and no Custom Organization Assignment value is entered, the field will be
     * left empty.
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_Assignment_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Y, the existing custom organization listed in the Custom Organization Assignment column is deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Custom_Organization_Assignment_DataType
     * @uses Custom_Organization_Assignment_DataType::setCustom_Organization_Assignment_Reference()
     * @uses Custom_Organization_Assignment_DataType::setDelete()
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_Assignment_Reference
     * @param bool $delete
     */
    public function __construct(\StructType\Custom_OrganizationObjectType $custom_Organization_Assignment_Reference = null, $delete = null)
    {
        $this
            ->setCustom_Organization_Assignment_Reference($custom_Organization_Assignment_Reference)
            ->setDelete($delete);
    }
    /**
     * Get Custom_Organization_Assignment_Reference value
     * @return \StructType\Custom_OrganizationObjectType|null
     */
    public function getCustom_Organization_Assignment_Reference()
    {
        return $this->Custom_Organization_Assignment_Reference;
    }
    /**
     * Set Custom_Organization_Assignment_Reference value
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_Assignment_Reference
     * @return \StructType\Custom_Organization_Assignment_DataType
     */
    public function setCustom_Organization_Assignment_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_Assignment_Reference = null)
    {
        $this->Custom_Organization_Assignment_Reference = $custom_Organization_Assignment_Reference;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Custom_Organization_Assignment_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
