<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Custom_IDType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element for all Custom Identifier data.
 * @subpackage Structs
 */
class Custom_IDType extends AbstractStructBase
{
    /**
     * The Custom_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for Custom Identifier.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Custom_ID_Reference;
    /**
     * The Custom_ID_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Custom Identifier data.
     * - minOccurs: 0
     * @var \StructType\Custom_ID_DataType
     */
    public $Custom_ID_Data;
    /**
     * The Custom_ID_Shared_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shared Reference ID for Custom Identifiers.
     * - minOccurs: 0
     * @var \StructType\Custom_Identifier_ReferenceObjectType
     */
    public $Custom_ID_Shared_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Delete is set to True and Replace All has been set to False, the ID will be deleted when the web service is submitted.Note: The Replace All flag defaults to False if not specified in the web service
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Custom_IDType
     * @uses Custom_IDType::setCustom_ID_Reference()
     * @uses Custom_IDType::setCustom_ID_Data()
     * @uses Custom_IDType::setCustom_ID_Shared_Reference()
     * @uses Custom_IDType::setDelete()
     * @param \StructType\Unique_IdentifierObjectType $custom_ID_Reference
     * @param \StructType\Custom_ID_DataType $custom_ID_Data
     * @param \StructType\Custom_Identifier_ReferenceObjectType $custom_ID_Shared_Reference
     * @param bool $delete
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $custom_ID_Reference = null, \StructType\Custom_ID_DataType $custom_ID_Data = null, \StructType\Custom_Identifier_ReferenceObjectType $custom_ID_Shared_Reference = null, $delete = null)
    {
        $this
            ->setCustom_ID_Reference($custom_ID_Reference)
            ->setCustom_ID_Data($custom_ID_Data)
            ->setCustom_ID_Shared_Reference($custom_ID_Shared_Reference)
            ->setDelete($delete);
    }
    /**
     * Get Custom_ID_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getCustom_ID_Reference()
    {
        return $this->Custom_ID_Reference;
    }
    /**
     * Set Custom_ID_Reference value
     * @param \StructType\Unique_IdentifierObjectType $custom_ID_Reference
     * @return \StructType\Custom_IDType
     */
    public function setCustom_ID_Reference(\StructType\Unique_IdentifierObjectType $custom_ID_Reference = null)
    {
        $this->Custom_ID_Reference = $custom_ID_Reference;
        return $this;
    }
    /**
     * Get Custom_ID_Data value
     * @return \StructType\Custom_ID_DataType|null
     */
    public function getCustom_ID_Data()
    {
        return $this->Custom_ID_Data;
    }
    /**
     * Set Custom_ID_Data value
     * @param \StructType\Custom_ID_DataType $custom_ID_Data
     * @return \StructType\Custom_IDType
     */
    public function setCustom_ID_Data(\StructType\Custom_ID_DataType $custom_ID_Data = null)
    {
        $this->Custom_ID_Data = $custom_ID_Data;
        return $this;
    }
    /**
     * Get Custom_ID_Shared_Reference value
     * @return \StructType\Custom_Identifier_ReferenceObjectType|null
     */
    public function getCustom_ID_Shared_Reference()
    {
        return $this->Custom_ID_Shared_Reference;
    }
    /**
     * Set Custom_ID_Shared_Reference value
     * @param \StructType\Custom_Identifier_ReferenceObjectType $custom_ID_Shared_Reference
     * @return \StructType\Custom_IDType
     */
    public function setCustom_ID_Shared_Reference(\StructType\Custom_Identifier_ReferenceObjectType $custom_ID_Shared_Reference = null)
    {
        $this->Custom_ID_Shared_Reference = $custom_ID_Shared_Reference;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Custom_IDType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
