<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Create_Position_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the creation of a new position opening for a supervisory organization using position management.
 * @subpackage Structs
 */
class Create_Position_DataType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the supervisory organization this position is being created for. This supervisory organization must be using the position management staffing model.
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Position_Request_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the reason the position is being created.
     * - minOccurs: 0
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Position_Request_Reason_Reference;
    /**
     * The Position_Data
     * @var \StructType\Position_Definition_DataType
     */
    public $Position_Data;
    /**
     * The Qualification_Replacement_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType
     */
    public $Qualification_Replacement_Data;
    /**
     * The Position_Group_Restrictions_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position_Group_Restriction_DataType
     */
    public $Position_Group_Restrictions_Data;
    /**
     * The Position_Restriction_Working_Hours_Details_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Working_Hours_Details_DataType
     */
    public $Position_Restriction_Working_Hours_Details_Data;
    /**
     * The Edit_Assign_Organization_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType
     */
    public $Edit_Assign_Organization_Sub_Process;
    /**
     * The Request_Default_Compensation_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_Compensation_Default_Sub_Business_ProcessType
     */
    public $Request_Default_Compensation_Sub_Process;
    /**
     * The Assign_Pay_Group_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Contains the Assign Pay Group for Position Restriction sub business process attributes and data needed to complete that sub process in the Create Position parent business process. This is currently only required to enable commitment
     * accounting for open positions.
     * - minOccurs: 0
     * @var \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType
     */
    public $Assign_Pay_Group_Sub_Process;
    /**
     * The Assign_Costing_Allocation_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Specifies the costing allocation overrides for the position.
     * - minOccurs: 0
     * @var \StructType\Assign_Costing_Allocation_Sub_Business_ProcessType
     */
    public $Assign_Costing_Allocation_Sub_Process;
    /**
     * Constructor method for Create_Position_DataType
     * @uses Create_Position_DataType::setSupervisory_Organization_Reference()
     * @uses Create_Position_DataType::setPosition_Request_Reason_Reference()
     * @uses Create_Position_DataType::setPosition_Data()
     * @uses Create_Position_DataType::setQualification_Replacement_Data()
     * @uses Create_Position_DataType::setPosition_Group_Restrictions_Data()
     * @uses Create_Position_DataType::setPosition_Restriction_Working_Hours_Details_Data()
     * @uses Create_Position_DataType::setEdit_Assign_Organization_Sub_Process()
     * @uses Create_Position_DataType::setRequest_Default_Compensation_Sub_Process()
     * @uses Create_Position_DataType::setAssign_Pay_Group_Sub_Process()
     * @uses Create_Position_DataType::setAssign_Costing_Allocation_Sub_Process()
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $position_Request_Reason_Reference
     * @param \StructType\Position_Definition_DataType $position_Data
     * @param \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data
     * @param \StructType\Position_Group_Restriction_DataType $position_Group_Restrictions_Data
     * @param \StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data
     * @param \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process
     * @param \StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process
     * @param \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process
     * @param \StructType\Assign_Costing_Allocation_Sub_Business_ProcessType $assign_Costing_Allocation_Sub_Process
     */
    public function __construct(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $position_Request_Reason_Reference = null, \StructType\Position_Definition_DataType $position_Data = null, \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data = null, \StructType\Position_Group_Restriction_DataType $position_Group_Restrictions_Data = null, \StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data = null, \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process = null, \StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process = null, \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process = null, \StructType\Assign_Costing_Allocation_Sub_Business_ProcessType $assign_Costing_Allocation_Sub_Process = null)
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setPosition_Request_Reason_Reference($position_Request_Reason_Reference)
            ->setPosition_Data($position_Data)
            ->setQualification_Replacement_Data($qualification_Replacement_Data)
            ->setPosition_Group_Restrictions_Data($position_Group_Restrictions_Data)
            ->setPosition_Restriction_Working_Hours_Details_Data($position_Restriction_Working_Hours_Details_Data)
            ->setEdit_Assign_Organization_Sub_Process($edit_Assign_Organization_Sub_Process)
            ->setRequest_Default_Compensation_Sub_Process($request_Default_Compensation_Sub_Process)
            ->setAssign_Pay_Group_Sub_Process($assign_Pay_Group_Sub_Process)
            ->setAssign_Costing_Allocation_Sub_Process($assign_Costing_Allocation_Sub_Process);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Create_Position_DataType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Position_Request_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getPosition_Request_Reason_Reference()
    {
        return $this->Position_Request_Reason_Reference;
    }
    /**
     * Set Position_Request_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $position_Request_Reason_Reference
     * @return \StructType\Create_Position_DataType
     */
    public function setPosition_Request_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $position_Request_Reason_Reference = null)
    {
        $this->Position_Request_Reason_Reference = $position_Request_Reason_Reference;
        return $this;
    }
    /**
     * Get Position_Data value
     * @return \StructType\Position_Definition_DataType|null
     */
    public function getPosition_Data()
    {
        return $this->Position_Data;
    }
    /**
     * Set Position_Data value
     * @param \StructType\Position_Definition_DataType $position_Data
     * @return \StructType\Create_Position_DataType
     */
    public function setPosition_Data(\StructType\Position_Definition_DataType $position_Data = null)
    {
        $this->Position_Data = $position_Data;
        return $this;
    }
    /**
     * Get Qualification_Replacement_Data value
     * @return \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType|null
     */
    public function getQualification_Replacement_Data()
    {
        return $this->Qualification_Replacement_Data;
    }
    /**
     * Set Qualification_Replacement_Data value
     * @param \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data
     * @return \StructType\Create_Position_DataType
     */
    public function setQualification_Replacement_Data(\StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data = null)
    {
        $this->Qualification_Replacement_Data = $qualification_Replacement_Data;
        return $this;
    }
    /**
     * Get Position_Group_Restrictions_Data value
     * @return \StructType\Position_Group_Restriction_DataType|null
     */
    public function getPosition_Group_Restrictions_Data()
    {
        return $this->Position_Group_Restrictions_Data;
    }
    /**
     * Set Position_Group_Restrictions_Data value
     * @param \StructType\Position_Group_Restriction_DataType $position_Group_Restrictions_Data
     * @return \StructType\Create_Position_DataType
     */
    public function setPosition_Group_Restrictions_Data(\StructType\Position_Group_Restriction_DataType $position_Group_Restrictions_Data = null)
    {
        $this->Position_Group_Restrictions_Data = $position_Group_Restrictions_Data;
        return $this;
    }
    /**
     * Get Position_Restriction_Working_Hours_Details_Data value
     * @return \StructType\Working_Hours_Details_DataType|null
     */
    public function getPosition_Restriction_Working_Hours_Details_Data()
    {
        return $this->Position_Restriction_Working_Hours_Details_Data;
    }
    /**
     * Set Position_Restriction_Working_Hours_Details_Data value
     * @param \StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data
     * @return \StructType\Create_Position_DataType
     */
    public function setPosition_Restriction_Working_Hours_Details_Data(\StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data = null)
    {
        $this->Position_Restriction_Working_Hours_Details_Data = $position_Restriction_Working_Hours_Details_Data;
        return $this;
    }
    /**
     * Get Edit_Assign_Organization_Sub_Process value
     * @return \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType|null
     */
    public function getEdit_Assign_Organization_Sub_Process()
    {
        return $this->Edit_Assign_Organization_Sub_Process;
    }
    /**
     * Set Edit_Assign_Organization_Sub_Process value
     * @param \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process
     * @return \StructType\Create_Position_DataType
     */
    public function setEdit_Assign_Organization_Sub_Process(\StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType $edit_Assign_Organization_Sub_Process = null)
    {
        $this->Edit_Assign_Organization_Sub_Process = $edit_Assign_Organization_Sub_Process;
        return $this;
    }
    /**
     * Get Request_Default_Compensation_Sub_Process value
     * @return \StructType\Request_Compensation_Default_Sub_Business_ProcessType|null
     */
    public function getRequest_Default_Compensation_Sub_Process()
    {
        return $this->Request_Default_Compensation_Sub_Process;
    }
    /**
     * Set Request_Default_Compensation_Sub_Process value
     * @param \StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process
     * @return \StructType\Create_Position_DataType
     */
    public function setRequest_Default_Compensation_Sub_Process(\StructType\Request_Compensation_Default_Sub_Business_ProcessType $request_Default_Compensation_Sub_Process = null)
    {
        $this->Request_Default_Compensation_Sub_Process = $request_Default_Compensation_Sub_Process;
        return $this;
    }
    /**
     * Get Assign_Pay_Group_Sub_Process value
     * @return \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType|null
     */
    public function getAssign_Pay_Group_Sub_Process()
    {
        return $this->Assign_Pay_Group_Sub_Process;
    }
    /**
     * Set Assign_Pay_Group_Sub_Process value
     * @param \StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process
     * @return \StructType\Create_Position_DataType
     */
    public function setAssign_Pay_Group_Sub_Process(\StructType\Assign_Pay_Group_for_Position_Restrictions_Sub_Business_ProcessType $assign_Pay_Group_Sub_Process = null)
    {
        $this->Assign_Pay_Group_Sub_Process = $assign_Pay_Group_Sub_Process;
        return $this;
    }
    /**
     * Get Assign_Costing_Allocation_Sub_Process value
     * @return \StructType\Assign_Costing_Allocation_Sub_Business_ProcessType|null
     */
    public function getAssign_Costing_Allocation_Sub_Process()
    {
        return $this->Assign_Costing_Allocation_Sub_Process;
    }
    /**
     * Set Assign_Costing_Allocation_Sub_Process value
     * @param \StructType\Assign_Costing_Allocation_Sub_Business_ProcessType $assign_Costing_Allocation_Sub_Process
     * @return \StructType\Create_Position_DataType
     */
    public function setAssign_Costing_Allocation_Sub_Process(\StructType\Assign_Costing_Allocation_Sub_Business_ProcessType $assign_Costing_Allocation_Sub_Process = null)
    {
        $this->Assign_Costing_Allocation_Sub_Process = $assign_Costing_Allocation_Sub_Process;
        return $this;
    }
}
