<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Costing_Interval_Update_KeyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Submit only when updating or deleting an existing Costing Allocation Interval. One key (Costing Override ID or Start Date) is required.
 * @subpackage Structs
 */
class Costing_Interval_Update_KeyType extends AbstractStructBase
{
    /**
     * The Costing_Override_ID_Update_Key
     * Meta information extracted from the WSDL
     * - documentation: The existing Costing Allocation Interval to be updated may be identified using either its Costing Override ID or its Start Date.
     * - choice: Costing_Override_ID_Update_Key | Start_Date_Update_Key
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $Costing_Override_ID_Update_Key;
    /**
     * The Start_Date_Update_Key
     * Meta information extracted from the WSDL
     * - documentation: The existing Costing Allocation Interval to be updated may be identified using either its Costing Override ID or its Start Date.
     * - choice: Costing_Override_ID_Update_Key | Start_Date_Update_Key
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date_Update_Key;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Select Yes (Y) to delete the existing Costing Allocation Interval identified by the submitted key value.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Costing_Interval_Update_KeyType
     * @uses Costing_Interval_Update_KeyType::setCosting_Override_ID_Update_Key()
     * @uses Costing_Interval_Update_KeyType::setStart_Date_Update_Key()
     * @uses Costing_Interval_Update_KeyType::setDelete()
     * @param string $costing_Override_ID_Update_Key
     * @param string $start_Date_Update_Key
     * @param bool $delete
     */
    public function __construct($costing_Override_ID_Update_Key = null, $start_Date_Update_Key = null, $delete = null)
    {
        $this
            ->setCosting_Override_ID_Update_Key($costing_Override_ID_Update_Key)
            ->setStart_Date_Update_Key($start_Date_Update_Key)
            ->setDelete($delete);
    }
    /**
     * Get Costing_Override_ID_Update_Key value
     * @return string|null
     */
    public function getCosting_Override_ID_Update_Key()
    {
        return isset($this->Costing_Override_ID_Update_Key) ? $this->Costing_Override_ID_Update_Key : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCosting_Override_ID_Update_Key method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCosting_Override_ID_Update_Key method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCosting_Override_ID_Update_KeyForChoiceConstraintsFromSetCosting_Override_ID_Update_Key($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Start_Date_Update_Key',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Costing_Override_ID_Update_Key can\'t be set as the property %s is already set. Only one property must be set among these properties: Costing_Override_ID_Update_Key, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Costing_Override_ID_Update_Key value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $costing_Override_ID_Update_Key
     * @return \StructType\Costing_Interval_Update_KeyType
     */
    public function setCosting_Override_ID_Update_Key($costing_Override_ID_Update_Key = null)
    {
        // validation for constraint: string
        if (!is_null($costing_Override_ID_Update_Key) && !is_string($costing_Override_ID_Update_Key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costing_Override_ID_Update_Key, true), gettype($costing_Override_ID_Update_Key)), __LINE__);
        }
        // validation for constraint: choice(Costing_Override_ID_Update_Key, Start_Date_Update_Key)
        if ('' !== ($costing_Override_ID_Update_KeyChoiceErrorMessage = self::validateCosting_Override_ID_Update_KeyForChoiceConstraintsFromSetCosting_Override_ID_Update_Key($costing_Override_ID_Update_Key))) {
            throw new \InvalidArgumentException($costing_Override_ID_Update_KeyChoiceErrorMessage, __LINE__);
        }
        if (is_null($costing_Override_ID_Update_Key) || (is_array($costing_Override_ID_Update_Key) && empty($costing_Override_ID_Update_Key))) {
            unset($this->Costing_Override_ID_Update_Key);
        } else {
            $this->Costing_Override_ID_Update_Key = $costing_Override_ID_Update_Key;
        }
        return $this;
    }
    /**
     * Get Start_Date_Update_Key value
     * @return string|null
     */
    public function getStart_Date_Update_Key()
    {
        return isset($this->Start_Date_Update_Key) ? $this->Start_Date_Update_Key : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStart_Date_Update_Key method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart_Date_Update_Key method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStart_Date_Update_KeyForChoiceConstraintsFromSetStart_Date_Update_Key($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Costing_Override_ID_Update_Key',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Start_Date_Update_Key can\'t be set as the property %s is already set. Only one property must be set among these properties: Start_Date_Update_Key, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Start_Date_Update_Key value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $start_Date_Update_Key
     * @return \StructType\Costing_Interval_Update_KeyType
     */
    public function setStart_Date_Update_Key($start_Date_Update_Key = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_Update_Key) && !is_string($start_Date_Update_Key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_Update_Key, true), gettype($start_Date_Update_Key)), __LINE__);
        }
        // validation for constraint: choice(Costing_Override_ID_Update_Key, Start_Date_Update_Key)
        if ('' !== ($start_Date_Update_KeyChoiceErrorMessage = self::validateStart_Date_Update_KeyForChoiceConstraintsFromSetStart_Date_Update_Key($start_Date_Update_Key))) {
            throw new \InvalidArgumentException($start_Date_Update_KeyChoiceErrorMessage, __LINE__);
        }
        if (is_null($start_Date_Update_Key) || (is_array($start_Date_Update_Key) && empty($start_Date_Update_Key))) {
            unset($this->Start_Date_Update_Key);
        } else {
            $this->Start_Date_Update_Key = $start_Date_Update_Key;
        }
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Costing_Interval_Update_KeyType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
