<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Worker_Cost_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains all information related to hiring/contracting a contingent worker. This information only needs to be filled in if the worker type is for an employee.
 * @subpackage Structs
 */
class Contingent_Worker_Cost_Information_DataType extends AbstractStructBase
{
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker requesting the new position.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Company_for_Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Company ID used on purchase orders.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_for_Purchase_Order_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: The supplier where the worker comes from.
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Currency ID to pay the worker.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Spend Category for this job requisition.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Pay_Rate
     * Meta information extracted from the WSDL
     * - documentation: The suggested pay rate for contract worker.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Pay_Rate;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The frequency the worker will be paid.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Maximum_Amount
     * Meta information extracted from the WSDL
     * - documentation: The maximum amount of time that the worker will be paid during the contract.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Maximum_Amount;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktag to help identify this worker in accounting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Contingent_Worker_Cost_Information_DataType
     * @uses Contingent_Worker_Cost_Information_DataType::setRequester_Reference()
     * @uses Contingent_Worker_Cost_Information_DataType::setCompany_for_Purchase_Order_Reference()
     * @uses Contingent_Worker_Cost_Information_DataType::setSupplier_Reference()
     * @uses Contingent_Worker_Cost_Information_DataType::setCurrency_Reference()
     * @uses Contingent_Worker_Cost_Information_DataType::setSpend_Category_Reference()
     * @uses Contingent_Worker_Cost_Information_DataType::setPay_Rate()
     * @uses Contingent_Worker_Cost_Information_DataType::setFrequency_Reference()
     * @uses Contingent_Worker_Cost_Information_DataType::setMaximum_Amount()
     * @uses Contingent_Worker_Cost_Information_DataType::setWorktags_Reference()
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\CompanyObjectType $company_for_Purchase_Order_Reference
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param float $pay_Rate
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param float $maximum_Amount
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct(\StructType\WorkerObjectType $requester_Reference = null, \StructType\CompanyObjectType $company_for_Purchase_Order_Reference = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $pay_Rate = null, \StructType\FrequencyObjectType $frequency_Reference = null, $maximum_Amount = null, array $worktags_Reference = array())
    {
        $this
            ->setRequester_Reference($requester_Reference)
            ->setCompany_for_Purchase_Order_Reference($company_for_Purchase_Order_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setPay_Rate($pay_Rate)
            ->setFrequency_Reference($frequency_Reference)
            ->setMaximum_Amount($maximum_Amount)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Company_for_Purchase_Order_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_for_Purchase_Order_Reference()
    {
        return $this->Company_for_Purchase_Order_Reference;
    }
    /**
     * Set Company_for_Purchase_Order_Reference value
     * @param \StructType\CompanyObjectType $company_for_Purchase_Order_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setCompany_for_Purchase_Order_Reference(\StructType\CompanyObjectType $company_for_Purchase_Order_Reference = null)
    {
        $this->Company_for_Purchase_Order_Reference = $company_for_Purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Pay_Rate value
     * @return float|null
     */
    public function getPay_Rate()
    {
        return $this->Pay_Rate;
    }
    /**
     * Set Pay_Rate value
     * @param float $pay_Rate
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setPay_Rate($pay_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($pay_Rate) && !(is_float($pay_Rate) || is_numeric($pay_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pay_Rate, true), gettype($pay_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($pay_Rate) && mb_strlen(mb_substr($pay_Rate, false !== mb_strpos($pay_Rate, '.') ? mb_strpos($pay_Rate, '.') + 1 : mb_strlen($pay_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($pay_Rate, true), mb_strlen(mb_substr($pay_Rate, mb_strpos($pay_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_Rate) && $pay_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($pay_Rate) && mb_strlen(preg_replace('/(\D)/', '', $pay_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($pay_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $pay_Rate))), __LINE__);
        }
        $this->Pay_Rate = $pay_Rate;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Maximum_Amount value
     * @return float|null
     */
    public function getMaximum_Amount()
    {
        return $this->Maximum_Amount;
    }
    /**
     * Set Maximum_Amount value
     * @param float $maximum_Amount
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setMaximum_Amount($maximum_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($maximum_Amount) && !(is_float($maximum_Amount) || is_numeric($maximum_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum_Amount, true), gettype($maximum_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($maximum_Amount) && mb_strlen(mb_substr($maximum_Amount, false !== mb_strpos($maximum_Amount, '.') ? mb_strpos($maximum_Amount, '.') + 1 : mb_strlen($maximum_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($maximum_Amount, true), mb_strlen(mb_substr($maximum_Amount, mb_strpos($maximum_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($maximum_Amount) && $maximum_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($maximum_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($maximum_Amount) && mb_strlen(preg_replace('/(\D)/', '', $maximum_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($maximum_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $maximum_Amount))), __LINE__);
        }
        $this->Maximum_Amount = $maximum_Amount;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Cost_Information_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Cost_Information_DataTypeWorktags_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($contingent_Worker_Cost_Information_DataTypeWorktags_ReferenceItem) ? get_class($contingent_Worker_Cost_Information_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($contingent_Worker_Cost_Information_DataTypeWorktags_ReferenceItem), var_export($contingent_Worker_Cost_Information_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Contingent_Worker_Cost_Information_DataType
     */
    public function addToWorktags_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
