<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Websites_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Duplicate URL Addresses are not allowed. | URL Address must start with "http://" or "https://" | Add websites for the Candidate.
 * @subpackage Structs
 */
class Candidate_Websites_DataType extends AbstractStructBase
{
    /**
     * The URL_Address
     * Meta information extracted from the WSDL
     * - documentation: URL Address for the Candidate Website.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL_Address;
    /**
     * Constructor method for Candidate_Websites_DataType
     * @uses Candidate_Websites_DataType::setURL_Address()
     * @param string $uRL_Address
     */
    public function __construct($uRL_Address = null)
    {
        $this
            ->setURL_Address($uRL_Address);
    }
    /**
     * Get URL_Address value
     * @return string|null
     */
    public function getURL_Address()
    {
        return $this->URL_Address;
    }
    /**
     * Set URL_Address value
     * @param string $uRL_Address
     * @return \StructType\Candidate_Websites_DataType
     */
    public function setURL_Address($uRL_Address = null)
    {
        // validation for constraint: string
        if (!is_null($uRL_Address) && !is_string($uRL_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL_Address, true), gettype($uRL_Address)), __LINE__);
        }
        $this->URL_Address = $uRL_Address;
        return $this;
    }
}
