<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Specialty_Achievement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains data about each Specialty-Subspecialty combination associated with the certification
 * @subpackage Structs
 */
class Candidate_Specialty_Achievement_DataType extends AbstractStructBase
{
    /**
     * The Specialty_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter the Speciality associated with the certification achievement.
     * @var \StructType\Specialty_ParentObjectType
     */
    public $Specialty_Reference;
    /**
     * The Specialty_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Enter the Specialty Start Date associated with this certification achievement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Specialty_Start_Date;
    /**
     * The Specialty_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Enter the Specialty End Date associated with this certification achievement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Specialty_End_Date;
    /**
     * The Subspecialty_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter the subspecialty ID associated with the specialty.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Specialty_ChildObjectType[]
     */
    public $Subspecialty_Reference;
    /**
     * Constructor method for Candidate_Specialty_Achievement_DataType
     * @uses Candidate_Specialty_Achievement_DataType::setSpecialty_Reference()
     * @uses Candidate_Specialty_Achievement_DataType::setSpecialty_Start_Date()
     * @uses Candidate_Specialty_Achievement_DataType::setSpecialty_End_Date()
     * @uses Candidate_Specialty_Achievement_DataType::setSubspecialty_Reference()
     * @param \StructType\Specialty_ParentObjectType $specialty_Reference
     * @param string $specialty_Start_Date
     * @param string $specialty_End_Date
     * @param \StructType\Specialty_ChildObjectType[] $subspecialty_Reference
     */
    public function __construct(\StructType\Specialty_ParentObjectType $specialty_Reference = null, $specialty_Start_Date = null, $specialty_End_Date = null, array $subspecialty_Reference = array())
    {
        $this
            ->setSpecialty_Reference($specialty_Reference)
            ->setSpecialty_Start_Date($specialty_Start_Date)
            ->setSpecialty_End_Date($specialty_End_Date)
            ->setSubspecialty_Reference($subspecialty_Reference);
    }
    /**
     * Get Specialty_Reference value
     * @return \StructType\Specialty_ParentObjectType|null
     */
    public function getSpecialty_Reference()
    {
        return $this->Specialty_Reference;
    }
    /**
     * Set Specialty_Reference value
     * @param \StructType\Specialty_ParentObjectType $specialty_Reference
     * @return \StructType\Candidate_Specialty_Achievement_DataType
     */
    public function setSpecialty_Reference(\StructType\Specialty_ParentObjectType $specialty_Reference = null)
    {
        $this->Specialty_Reference = $specialty_Reference;
        return $this;
    }
    /**
     * Get Specialty_Start_Date value
     * @return string|null
     */
    public function getSpecialty_Start_Date()
    {
        return $this->Specialty_Start_Date;
    }
    /**
     * Set Specialty_Start_Date value
     * @param string $specialty_Start_Date
     * @return \StructType\Candidate_Specialty_Achievement_DataType
     */
    public function setSpecialty_Start_Date($specialty_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($specialty_Start_Date) && !is_string($specialty_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialty_Start_Date, true), gettype($specialty_Start_Date)), __LINE__);
        }
        $this->Specialty_Start_Date = $specialty_Start_Date;
        return $this;
    }
    /**
     * Get Specialty_End_Date value
     * @return string|null
     */
    public function getSpecialty_End_Date()
    {
        return $this->Specialty_End_Date;
    }
    /**
     * Set Specialty_End_Date value
     * @param string $specialty_End_Date
     * @return \StructType\Candidate_Specialty_Achievement_DataType
     */
    public function setSpecialty_End_Date($specialty_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($specialty_End_Date) && !is_string($specialty_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialty_End_Date, true), gettype($specialty_End_Date)), __LINE__);
        }
        $this->Specialty_End_Date = $specialty_End_Date;
        return $this;
    }
    /**
     * Get Subspecialty_Reference value
     * @return \StructType\Specialty_ChildObjectType[]|null
     */
    public function getSubspecialty_Reference()
    {
        return $this->Subspecialty_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSubspecialty_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubspecialty_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubspecialty_ReferenceForArrayConstraintsFromSetSubspecialty_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Specialty_Achievement_DataTypeSubspecialty_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Specialty_Achievement_DataTypeSubspecialty_ReferenceItem instanceof \StructType\Specialty_ChildObjectType) {
                $invalidValues[] = is_object($candidate_Specialty_Achievement_DataTypeSubspecialty_ReferenceItem) ? get_class($candidate_Specialty_Achievement_DataTypeSubspecialty_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Specialty_Achievement_DataTypeSubspecialty_ReferenceItem), var_export($candidate_Specialty_Achievement_DataTypeSubspecialty_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Subspecialty_Reference property can only contain items of type \StructType\Specialty_ChildObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Subspecialty_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Specialty_ChildObjectType[] $subspecialty_Reference
     * @return \StructType\Candidate_Specialty_Achievement_DataType
     */
    public function setSubspecialty_Reference(array $subspecialty_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($subspecialty_ReferenceArrayErrorMessage = self::validateSubspecialty_ReferenceForArrayConstraintsFromSetSubspecialty_Reference($subspecialty_Reference))) {
            throw new \InvalidArgumentException($subspecialty_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Subspecialty_Reference = $subspecialty_Reference;
        return $this;
    }
    /**
     * Add item to Subspecialty_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Specialty_ChildObjectType $item
     * @return \StructType\Candidate_Specialty_Achievement_DataType
     */
    public function addToSubspecialty_Reference(\StructType\Specialty_ChildObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Specialty_ChildObjectType) {
            throw new \InvalidArgumentException(sprintf('The Subspecialty_Reference property can only contain items of type \StructType\Specialty_ChildObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Subspecialty_Reference[] = $item;
        return $this;
    }
}
