<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the following criteria options to search for Candidates within the Workday system. The Candidate references that are returned are those that satisfy ALL criteria included in the request. Therefore, the result set will become
 * more limited with every criterium that is populated.
 * @subpackage Structs
 */
class Candidate_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The First_Name
     * Meta information extracted from the WSDL
     * - documentation: The first name (given name) for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $First_Name;
    /**
     * The Last_Name
     * Meta information extracted from the WSDL
     * - documentation: The last name for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Name;
    /**
     * The Candidate_Email_Address
     * Meta information extracted from the WSDL
     * - documentation: The public primary email address for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Candidate_Email_Address;
    /**
     * The Pre_Hire_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the pre-hire that is the candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ApplicantObjectType[]
     */
    public $Pre_Hire_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the worker that is the candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Worker_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the job requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType[]
     */
    public $Job_Requisition_Reference;
    /**
     * The Recruiting_Stage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a recruiting stage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Stage__Workday_Owned_ObjectType[]
     */
    public $Recruiting_Stage_Reference;
    /**
     * The Applicant_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an applicant source.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Applicant_SourceObjectType[]
     */
    public $Applicant_Source_Reference;
    /**
     * The Candidate_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the candidate tags for the candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_TagObjectType[]
     */
    public $Candidate_Tag_Reference;
    /**
     * The Applied_From
     * Meta information extracted from the WSDL
     * - documentation: Find Candidates who applied after this date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Applied_From;
    /**
     * The Applied_Through
     * Meta information extracted from the WSDL
     * - documentation: Find Candidates who applied up to this date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Applied_Through;
    /**
     * The Internal_Workers_Only
     * Meta information extracted from the WSDL
     * - documentation: Include Only Workers will only return internal candidates that are employees or contingent workers at the time of application.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Internal_Workers_Only;
    /**
     * The Created_From
     * Meta information extracted from the WSDL
     * - documentation: Find Candidates created after this date and time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created_From;
    /**
     * The Created_Through
     * Meta information extracted from the WSDL
     * - documentation: Find Candidates created up to this date and time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created_Through;
    /**
     * The Criteria_Match_Score_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Find Candidates that have these Score Categories.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Application_Skills_Match_Score_CategoryObjectType[]
     */
    public $Criteria_Match_Score_Category_Reference;
    /**
     * Constructor method for Candidate_Request_CriteriaType
     * @uses Candidate_Request_CriteriaType::setFirst_Name()
     * @uses Candidate_Request_CriteriaType::setLast_Name()
     * @uses Candidate_Request_CriteriaType::setCandidate_Email_Address()
     * @uses Candidate_Request_CriteriaType::setPre_Hire_Reference()
     * @uses Candidate_Request_CriteriaType::setWorker_Reference()
     * @uses Candidate_Request_CriteriaType::setJob_Requisition_Reference()
     * @uses Candidate_Request_CriteriaType::setRecruiting_Stage_Reference()
     * @uses Candidate_Request_CriteriaType::setApplicant_Source_Reference()
     * @uses Candidate_Request_CriteriaType::setCandidate_Tag_Reference()
     * @uses Candidate_Request_CriteriaType::setApplied_From()
     * @uses Candidate_Request_CriteriaType::setApplied_Through()
     * @uses Candidate_Request_CriteriaType::setInternal_Workers_Only()
     * @uses Candidate_Request_CriteriaType::setCreated_From()
     * @uses Candidate_Request_CriteriaType::setCreated_Through()
     * @uses Candidate_Request_CriteriaType::setCriteria_Match_Score_Category_Reference()
     * @param string $first_Name
     * @param string $last_Name
     * @param string $candidate_Email_Address
     * @param \StructType\ApplicantObjectType[] $pre_Hire_Reference
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType[] $job_Requisition_Reference
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType[] $recruiting_Stage_Reference
     * @param \StructType\Applicant_SourceObjectType[] $applicant_Source_Reference
     * @param \StructType\Candidate_TagObjectType[] $candidate_Tag_Reference
     * @param string $applied_From
     * @param string $applied_Through
     * @param bool $internal_Workers_Only
     * @param string $created_From
     * @param string $created_Through
     * @param \StructType\Job_Application_Skills_Match_Score_CategoryObjectType[] $criteria_Match_Score_Category_Reference
     */
    public function __construct($first_Name = null, $last_Name = null, $candidate_Email_Address = null, array $pre_Hire_Reference = array(), array $worker_Reference = array(), array $job_Requisition_Reference = array(), array $recruiting_Stage_Reference = array(), array $applicant_Source_Reference = array(), array $candidate_Tag_Reference = array(), $applied_From = null, $applied_Through = null, $internal_Workers_Only = null, $created_From = null, $created_Through = null, array $criteria_Match_Score_Category_Reference = array())
    {
        $this
            ->setFirst_Name($first_Name)
            ->setLast_Name($last_Name)
            ->setCandidate_Email_Address($candidate_Email_Address)
            ->setPre_Hire_Reference($pre_Hire_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setRecruiting_Stage_Reference($recruiting_Stage_Reference)
            ->setApplicant_Source_Reference($applicant_Source_Reference)
            ->setCandidate_Tag_Reference($candidate_Tag_Reference)
            ->setApplied_From($applied_From)
            ->setApplied_Through($applied_Through)
            ->setInternal_Workers_Only($internal_Workers_Only)
            ->setCreated_From($created_From)
            ->setCreated_Through($created_Through)
            ->setCriteria_Match_Score_Category_Reference($criteria_Match_Score_Category_Reference);
    }
    /**
     * Get First_Name value
     * @return string|null
     */
    public function getFirst_Name()
    {
        return $this->First_Name;
    }
    /**
     * Set First_Name value
     * @param string $first_Name
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setFirst_Name($first_Name = null)
    {
        // validation for constraint: string
        if (!is_null($first_Name) && !is_string($first_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Name, true), gettype($first_Name)), __LINE__);
        }
        $this->First_Name = $first_Name;
        return $this;
    }
    /**
     * Get Last_Name value
     * @return string|null
     */
    public function getLast_Name()
    {
        return $this->Last_Name;
    }
    /**
     * Set Last_Name value
     * @param string $last_Name
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setLast_Name($last_Name = null)
    {
        // validation for constraint: string
        if (!is_null($last_Name) && !is_string($last_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Name, true), gettype($last_Name)), __LINE__);
        }
        $this->Last_Name = $last_Name;
        return $this;
    }
    /**
     * Get Candidate_Email_Address value
     * @return string|null
     */
    public function getCandidate_Email_Address()
    {
        return $this->Candidate_Email_Address;
    }
    /**
     * Set Candidate_Email_Address value
     * @param string $candidate_Email_Address
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setCandidate_Email_Address($candidate_Email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($candidate_Email_Address) && !is_string($candidate_Email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidate_Email_Address, true), gettype($candidate_Email_Address)), __LINE__);
        }
        $this->Candidate_Email_Address = $candidate_Email_Address;
        return $this;
    }
    /**
     * Get Pre_Hire_Reference value
     * @return \StructType\ApplicantObjectType[]|null
     */
    public function getPre_Hire_Reference()
    {
        return $this->{'Pre-Hire_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setPre_Hire_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPre_Hire_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePre_Hire_ReferenceForArrayConstraintsFromSetPre_Hire_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypePre_Hire_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypePre_Hire_ReferenceItem instanceof \StructType\ApplicantObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypePre_Hire_ReferenceItem) ? get_class($candidate_Request_CriteriaTypePre_Hire_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypePre_Hire_ReferenceItem), var_export($candidate_Request_CriteriaTypePre_Hire_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pre_Hire_Reference property can only contain items of type \StructType\ApplicantObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pre_Hire_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicantObjectType[] $pre_Hire_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setPre_Hire_Reference(array $pre_Hire_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($pre_Hire_ReferenceArrayErrorMessage = self::validatePre_Hire_ReferenceForArrayConstraintsFromSetPre_Hire_Reference($pre_Hire_Reference))) {
            throw new \InvalidArgumentException($pre_Hire_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Pre_Hire_Reference = $this->{'Pre-Hire_Reference'} = $pre_Hire_Reference;
        return $this;
    }
    /**
     * Add item to Pre_Hire_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicantObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToPre_Hire_Reference(\StructType\ApplicantObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApplicantObjectType) {
            throw new \InvalidArgumentException(sprintf('The Pre_Hire_Reference property can only contain items of type \StructType\ApplicantObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pre_Hire_Reference[] = $this->{'Pre-Hire_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypeWorker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypeWorker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypeWorker_ReferenceItem) ? get_class($candidate_Request_CriteriaTypeWorker_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypeWorker_ReferenceItem), var_export($candidate_Request_CriteriaTypeWorker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setWorker_Reference(array $worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_ReferenceArrayErrorMessage = self::validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Add item to Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToWorker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType[]|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypeJob_Requisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypeJob_Requisition_ReferenceItem instanceof \StructType\Job_Requisition_EnabledObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypeJob_Requisition_ReferenceItem) ? get_class($candidate_Request_CriteriaTypeJob_Requisition_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypeJob_Requisition_ReferenceItem), var_export($candidate_Request_CriteriaTypeJob_Requisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType[] $job_Requisition_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setJob_Requisition_Reference(array $job_Requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_ReferenceArrayErrorMessage = self::validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference($job_Requisition_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_EnabledObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Reference[] = $item;
        return $this;
    }
    /**
     * Get Recruiting_Stage_Reference value
     * @return \StructType\Recruiting_Stage__Workday_Owned_ObjectType[]|null
     */
    public function getRecruiting_Stage_Reference()
    {
        return $this->Recruiting_Stage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Stage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Stage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Stage_ReferenceForArrayConstraintsFromSetRecruiting_Stage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypeRecruiting_Stage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypeRecruiting_Stage_ReferenceItem instanceof \StructType\Recruiting_Stage__Workday_Owned_ObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypeRecruiting_Stage_ReferenceItem) ? get_class($candidate_Request_CriteriaTypeRecruiting_Stage_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypeRecruiting_Stage_ReferenceItem), var_export($candidate_Request_CriteriaTypeRecruiting_Stage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Stage_Reference property can only contain items of type \StructType\Recruiting_Stage__Workday_Owned_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Stage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType[] $recruiting_Stage_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setRecruiting_Stage_Reference(array $recruiting_Stage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Stage_ReferenceArrayErrorMessage = self::validateRecruiting_Stage_ReferenceForArrayConstraintsFromSetRecruiting_Stage_Reference($recruiting_Stage_Reference))) {
            throw new \InvalidArgumentException($recruiting_Stage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Stage_Reference = $recruiting_Stage_Reference;
        return $this;
    }
    /**
     * Add item to Recruiting_Stage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToRecruiting_Stage_Reference(\StructType\Recruiting_Stage__Workday_Owned_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Stage__Workday_Owned_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Stage_Reference property can only contain items of type \StructType\Recruiting_Stage__Workday_Owned_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Stage_Reference[] = $item;
        return $this;
    }
    /**
     * Get Applicant_Source_Reference value
     * @return \StructType\Applicant_SourceObjectType[]|null
     */
    public function getApplicant_Source_Reference()
    {
        return $this->Applicant_Source_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicant_Source_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicant_Source_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicant_Source_ReferenceForArrayConstraintsFromSetApplicant_Source_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypeApplicant_Source_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypeApplicant_Source_ReferenceItem instanceof \StructType\Applicant_SourceObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypeApplicant_Source_ReferenceItem) ? get_class($candidate_Request_CriteriaTypeApplicant_Source_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypeApplicant_Source_ReferenceItem), var_export($candidate_Request_CriteriaTypeApplicant_Source_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Applicant_Source_Reference property can only contain items of type \StructType\Applicant_SourceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Applicant_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Applicant_SourceObjectType[] $applicant_Source_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setApplicant_Source_Reference(array $applicant_Source_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($applicant_Source_ReferenceArrayErrorMessage = self::validateApplicant_Source_ReferenceForArrayConstraintsFromSetApplicant_Source_Reference($applicant_Source_Reference))) {
            throw new \InvalidArgumentException($applicant_Source_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Applicant_Source_Reference = $applicant_Source_Reference;
        return $this;
    }
    /**
     * Add item to Applicant_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Applicant_SourceObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToApplicant_Source_Reference(\StructType\Applicant_SourceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Applicant_SourceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Applicant_Source_Reference property can only contain items of type \StructType\Applicant_SourceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Applicant_Source_Reference[] = $item;
        return $this;
    }
    /**
     * Get Candidate_Tag_Reference value
     * @return \StructType\Candidate_TagObjectType[]|null
     */
    public function getCandidate_Tag_Reference()
    {
        return $this->Candidate_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Tag_ReferenceForArrayConstraintsFromSetCandidate_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypeCandidate_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypeCandidate_Tag_ReferenceItem instanceof \StructType\Candidate_TagObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypeCandidate_Tag_ReferenceItem) ? get_class($candidate_Request_CriteriaTypeCandidate_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypeCandidate_Tag_ReferenceItem), var_export($candidate_Request_CriteriaTypeCandidate_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Tag_Reference property can only contain items of type \StructType\Candidate_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_TagObjectType[] $candidate_Tag_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setCandidate_Tag_Reference(array $candidate_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Tag_ReferenceArrayErrorMessage = self::validateCandidate_Tag_ReferenceForArrayConstraintsFromSetCandidate_Tag_Reference($candidate_Tag_Reference))) {
            throw new \InvalidArgumentException($candidate_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Tag_Reference = $candidate_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Candidate_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_TagObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToCandidate_Tag_Reference(\StructType\Candidate_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Tag_Reference property can only contain items of type \StructType\Candidate_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Applied_From value
     * @return string|null
     */
    public function getApplied_From()
    {
        return $this->Applied_From;
    }
    /**
     * Set Applied_From value
     * @param string $applied_From
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setApplied_From($applied_From = null)
    {
        // validation for constraint: string
        if (!is_null($applied_From) && !is_string($applied_From)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applied_From, true), gettype($applied_From)), __LINE__);
        }
        $this->Applied_From = $applied_From;
        return $this;
    }
    /**
     * Get Applied_Through value
     * @return string|null
     */
    public function getApplied_Through()
    {
        return $this->Applied_Through;
    }
    /**
     * Set Applied_Through value
     * @param string $applied_Through
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setApplied_Through($applied_Through = null)
    {
        // validation for constraint: string
        if (!is_null($applied_Through) && !is_string($applied_Through)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applied_Through, true), gettype($applied_Through)), __LINE__);
        }
        $this->Applied_Through = $applied_Through;
        return $this;
    }
    /**
     * Get Internal_Workers_Only value
     * @return bool|null
     */
    public function getInternal_Workers_Only()
    {
        return $this->Internal_Workers_Only;
    }
    /**
     * Set Internal_Workers_Only value
     * @param bool $internal_Workers_Only
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setInternal_Workers_Only($internal_Workers_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($internal_Workers_Only) && !is_bool($internal_Workers_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($internal_Workers_Only, true), gettype($internal_Workers_Only)), __LINE__);
        }
        $this->Internal_Workers_Only = $internal_Workers_Only;
        return $this;
    }
    /**
     * Get Created_From value
     * @return string|null
     */
    public function getCreated_From()
    {
        return $this->Created_From;
    }
    /**
     * Set Created_From value
     * @param string $created_From
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setCreated_From($created_From = null)
    {
        // validation for constraint: string
        if (!is_null($created_From) && !is_string($created_From)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_From, true), gettype($created_From)), __LINE__);
        }
        $this->Created_From = $created_From;
        return $this;
    }
    /**
     * Get Created_Through value
     * @return string|null
     */
    public function getCreated_Through()
    {
        return $this->Created_Through;
    }
    /**
     * Set Created_Through value
     * @param string $created_Through
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setCreated_Through($created_Through = null)
    {
        // validation for constraint: string
        if (!is_null($created_Through) && !is_string($created_Through)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_Through, true), gettype($created_Through)), __LINE__);
        }
        $this->Created_Through = $created_Through;
        return $this;
    }
    /**
     * Get Criteria_Match_Score_Category_Reference value
     * @return \StructType\Job_Application_Skills_Match_Score_CategoryObjectType[]|null
     */
    public function getCriteria_Match_Score_Category_Reference()
    {
        return $this->Criteria_Match_Score_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCriteria_Match_Score_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriteria_Match_Score_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriteria_Match_Score_Category_ReferenceForArrayConstraintsFromSetCriteria_Match_Score_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Request_CriteriaTypeCriteria_Match_Score_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Request_CriteriaTypeCriteria_Match_Score_Category_ReferenceItem instanceof \StructType\Job_Application_Skills_Match_Score_CategoryObjectType) {
                $invalidValues[] = is_object($candidate_Request_CriteriaTypeCriteria_Match_Score_Category_ReferenceItem) ? get_class($candidate_Request_CriteriaTypeCriteria_Match_Score_Category_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Request_CriteriaTypeCriteria_Match_Score_Category_ReferenceItem), var_export($candidate_Request_CriteriaTypeCriteria_Match_Score_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Criteria_Match_Score_Category_Reference property can only contain items of type \StructType\Job_Application_Skills_Match_Score_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Criteria_Match_Score_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Skills_Match_Score_CategoryObjectType[] $criteria_Match_Score_Category_Reference
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function setCriteria_Match_Score_Category_Reference(array $criteria_Match_Score_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($criteria_Match_Score_Category_ReferenceArrayErrorMessage = self::validateCriteria_Match_Score_Category_ReferenceForArrayConstraintsFromSetCriteria_Match_Score_Category_Reference($criteria_Match_Score_Category_Reference))) {
            throw new \InvalidArgumentException($criteria_Match_Score_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Criteria_Match_Score_Category_Reference = $criteria_Match_Score_Category_Reference;
        return $this;
    }
    /**
     * Add item to Criteria_Match_Score_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Skills_Match_Score_CategoryObjectType $item
     * @return \StructType\Candidate_Request_CriteriaType
     */
    public function addToCriteria_Match_Score_Category_Reference(\StructType\Job_Application_Skills_Match_Score_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Application_Skills_Match_Score_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Criteria_Match_Score_Category_Reference property can only contain items of type \StructType\Job_Application_Skills_Match_Score_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Criteria_Match_Score_Category_Reference[] = $item;
        return $this;
    }
}
