<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Name_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the components of a name, such as the First Name and Last Name.
 * @subpackage Structs
 */
class Candidate_Name_Detail_DataType extends AbstractStructBase
{
    /**
     * The Title_Reference
     * Meta information extracted from the WSDL
     * - documentation: The description of the reference to the Title of a Candidate.
     * - minOccurs: 0
     * @var \StructType\Country_Predefined_Person_Name_Component_ValueObjectType
     */
    public $Title_Reference;
    /**
     * The Salutation_Suffix_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Form of Address for a candidate. This is only valid for the country of Germany.
     * - minOccurs: 0
     * @var \StructType\Country_Predefined_Person_Name_Component_ValueObjectType
     */
    public $Salutation_Suffix_Reference;
    /**
     * The Full_Name
     * Meta information extracted from the WSDL
     * - documentation: Full Person Name is used by Malaysia and Singapore. It is designed for (eliminate space between these two words) Workers in these countries to enter their Full Legal Name. It is an attribute of Global Person Name Class and is not a
     * concatenation of First and Last Names.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Full_Name;
    /**
     * The First_Name
     * Meta information extracted from the WSDL
     * - documentation: The First Name (Given Name) for a candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $First_Name;
    /**
     * The Middle_Name
     * Meta information extracted from the WSDL
     * - documentation: The Middle Name for a candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Middle_Name;
    /**
     * The Hereditary_Suffix_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Hereditary Suffix for a candidate. This is only valid for the country of Australia.
     * - minOccurs: 0
     * @var \StructType\Country_Predefined_Person_Name_Component_ValueObjectType
     */
    public $Hereditary_Suffix_Reference;
    /**
     * The Last_Name
     * Meta information extracted from the WSDL
     * - documentation: The Last Name (Family Name) for a candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Name;
    /**
     * The Secondary_Last_Name
     * Meta information extracted from the WSDL
     * - documentation: The Secondary Last Name (Secondary Family Name) for a candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Secondary_Last_Name;
    /**
     * The Tertiary_Last_Name
     * Meta information extracted from the WSDL
     * - documentation: The Tertiary Last Name for a candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tertiary_Last_Name;
    /**
     * The Social_Suffix_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the description of Social Suffix for a candidate.
     * - minOccurs: 0
     * @var \StructType\Country_Predefined_Person_Name_Component_ValueObjectType
     */
    public $Social_Suffix_Reference;
    /**
     * The Local_Person_Name
     * Meta information extracted from the WSDL
     * - documentation: Contains the name components in local script for supporting countries.
     * - minOccurs: 0
     * @var \StructType\Candidate_Local_Name_Detail_DataType
     */
    public $Local_Person_Name;
    /**
     * Constructor method for Candidate_Name_Detail_DataType
     * @uses Candidate_Name_Detail_DataType::setTitle_Reference()
     * @uses Candidate_Name_Detail_DataType::setSalutation_Suffix_Reference()
     * @uses Candidate_Name_Detail_DataType::setFull_Name()
     * @uses Candidate_Name_Detail_DataType::setFirst_Name()
     * @uses Candidate_Name_Detail_DataType::setMiddle_Name()
     * @uses Candidate_Name_Detail_DataType::setHereditary_Suffix_Reference()
     * @uses Candidate_Name_Detail_DataType::setLast_Name()
     * @uses Candidate_Name_Detail_DataType::setSecondary_Last_Name()
     * @uses Candidate_Name_Detail_DataType::setTertiary_Last_Name()
     * @uses Candidate_Name_Detail_DataType::setSocial_Suffix_Reference()
     * @uses Candidate_Name_Detail_DataType::setLocal_Person_Name()
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $title_Reference
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $salutation_Suffix_Reference
     * @param string $full_Name
     * @param string $first_Name
     * @param string $middle_Name
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $hereditary_Suffix_Reference
     * @param string $last_Name
     * @param string $secondary_Last_Name
     * @param string $tertiary_Last_Name
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $social_Suffix_Reference
     * @param \StructType\Candidate_Local_Name_Detail_DataType $local_Person_Name
     */
    public function __construct(\StructType\Country_Predefined_Person_Name_Component_ValueObjectType $title_Reference = null, \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $salutation_Suffix_Reference = null, $full_Name = null, $first_Name = null, $middle_Name = null, \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $hereditary_Suffix_Reference = null, $last_Name = null, $secondary_Last_Name = null, $tertiary_Last_Name = null, \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $social_Suffix_Reference = null, \StructType\Candidate_Local_Name_Detail_DataType $local_Person_Name = null)
    {
        $this
            ->setTitle_Reference($title_Reference)
            ->setSalutation_Suffix_Reference($salutation_Suffix_Reference)
            ->setFull_Name($full_Name)
            ->setFirst_Name($first_Name)
            ->setMiddle_Name($middle_Name)
            ->setHereditary_Suffix_Reference($hereditary_Suffix_Reference)
            ->setLast_Name($last_Name)
            ->setSecondary_Last_Name($secondary_Last_Name)
            ->setTertiary_Last_Name($tertiary_Last_Name)
            ->setSocial_Suffix_Reference($social_Suffix_Reference)
            ->setLocal_Person_Name($local_Person_Name);
    }
    /**
     * Get Title_Reference value
     * @return \StructType\Country_Predefined_Person_Name_Component_ValueObjectType|null
     */
    public function getTitle_Reference()
    {
        return $this->Title_Reference;
    }
    /**
     * Set Title_Reference value
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $title_Reference
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setTitle_Reference(\StructType\Country_Predefined_Person_Name_Component_ValueObjectType $title_Reference = null)
    {
        $this->Title_Reference = $title_Reference;
        return $this;
    }
    /**
     * Get Salutation_Suffix_Reference value
     * @return \StructType\Country_Predefined_Person_Name_Component_ValueObjectType|null
     */
    public function getSalutation_Suffix_Reference()
    {
        return $this->Salutation_Suffix_Reference;
    }
    /**
     * Set Salutation_Suffix_Reference value
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $salutation_Suffix_Reference
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setSalutation_Suffix_Reference(\StructType\Country_Predefined_Person_Name_Component_ValueObjectType $salutation_Suffix_Reference = null)
    {
        $this->Salutation_Suffix_Reference = $salutation_Suffix_Reference;
        return $this;
    }
    /**
     * Get Full_Name value
     * @return string|null
     */
    public function getFull_Name()
    {
        return $this->Full_Name;
    }
    /**
     * Set Full_Name value
     * @param string $full_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setFull_Name($full_Name = null)
    {
        // validation for constraint: string
        if (!is_null($full_Name) && !is_string($full_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($full_Name, true), gettype($full_Name)), __LINE__);
        }
        $this->Full_Name = $full_Name;
        return $this;
    }
    /**
     * Get First_Name value
     * @return string|null
     */
    public function getFirst_Name()
    {
        return $this->First_Name;
    }
    /**
     * Set First_Name value
     * @param string $first_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setFirst_Name($first_Name = null)
    {
        // validation for constraint: string
        if (!is_null($first_Name) && !is_string($first_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Name, true), gettype($first_Name)), __LINE__);
        }
        $this->First_Name = $first_Name;
        return $this;
    }
    /**
     * Get Middle_Name value
     * @return string|null
     */
    public function getMiddle_Name()
    {
        return $this->Middle_Name;
    }
    /**
     * Set Middle_Name value
     * @param string $middle_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setMiddle_Name($middle_Name = null)
    {
        // validation for constraint: string
        if (!is_null($middle_Name) && !is_string($middle_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middle_Name, true), gettype($middle_Name)), __LINE__);
        }
        $this->Middle_Name = $middle_Name;
        return $this;
    }
    /**
     * Get Hereditary_Suffix_Reference value
     * @return \StructType\Country_Predefined_Person_Name_Component_ValueObjectType|null
     */
    public function getHereditary_Suffix_Reference()
    {
        return $this->Hereditary_Suffix_Reference;
    }
    /**
     * Set Hereditary_Suffix_Reference value
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $hereditary_Suffix_Reference
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setHereditary_Suffix_Reference(\StructType\Country_Predefined_Person_Name_Component_ValueObjectType $hereditary_Suffix_Reference = null)
    {
        $this->Hereditary_Suffix_Reference = $hereditary_Suffix_Reference;
        return $this;
    }
    /**
     * Get Last_Name value
     * @return string|null
     */
    public function getLast_Name()
    {
        return $this->Last_Name;
    }
    /**
     * Set Last_Name value
     * @param string $last_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setLast_Name($last_Name = null)
    {
        // validation for constraint: string
        if (!is_null($last_Name) && !is_string($last_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Name, true), gettype($last_Name)), __LINE__);
        }
        $this->Last_Name = $last_Name;
        return $this;
    }
    /**
     * Get Secondary_Last_Name value
     * @return string|null
     */
    public function getSecondary_Last_Name()
    {
        return $this->Secondary_Last_Name;
    }
    /**
     * Set Secondary_Last_Name value
     * @param string $secondary_Last_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setSecondary_Last_Name($secondary_Last_Name = null)
    {
        // validation for constraint: string
        if (!is_null($secondary_Last_Name) && !is_string($secondary_Last_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondary_Last_Name, true), gettype($secondary_Last_Name)), __LINE__);
        }
        $this->Secondary_Last_Name = $secondary_Last_Name;
        return $this;
    }
    /**
     * Get Tertiary_Last_Name value
     * @return string|null
     */
    public function getTertiary_Last_Name()
    {
        return $this->Tertiary_Last_Name;
    }
    /**
     * Set Tertiary_Last_Name value
     * @param string $tertiary_Last_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setTertiary_Last_Name($tertiary_Last_Name = null)
    {
        // validation for constraint: string
        if (!is_null($tertiary_Last_Name) && !is_string($tertiary_Last_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tertiary_Last_Name, true), gettype($tertiary_Last_Name)), __LINE__);
        }
        $this->Tertiary_Last_Name = $tertiary_Last_Name;
        return $this;
    }
    /**
     * Get Social_Suffix_Reference value
     * @return \StructType\Country_Predefined_Person_Name_Component_ValueObjectType|null
     */
    public function getSocial_Suffix_Reference()
    {
        return $this->Social_Suffix_Reference;
    }
    /**
     * Set Social_Suffix_Reference value
     * @param \StructType\Country_Predefined_Person_Name_Component_ValueObjectType $social_Suffix_Reference
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setSocial_Suffix_Reference(\StructType\Country_Predefined_Person_Name_Component_ValueObjectType $social_Suffix_Reference = null)
    {
        $this->Social_Suffix_Reference = $social_Suffix_Reference;
        return $this;
    }
    /**
     * Get Local_Person_Name value
     * @return \StructType\Candidate_Local_Name_Detail_DataType|null
     */
    public function getLocal_Person_Name()
    {
        return $this->Local_Person_Name;
    }
    /**
     * Set Local_Person_Name value
     * @param \StructType\Candidate_Local_Name_Detail_DataType $local_Person_Name
     * @return \StructType\Candidate_Name_Detail_DataType
     */
    public function setLocal_Person_Name(\StructType\Candidate_Local_Name_Detail_DataType $local_Person_Name = null)
    {
        $this->Local_Person_Name = $local_Person_Name;
        return $this;
    }
}
