<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains name data for a candidate.
 * @subpackage Structs
 */
class Candidate_Name_DataType extends AbstractStructBase
{
    /**
     * The Legal_Name
     * Meta information extracted from the WSDL
     * - documentation: Contains the legal name for a candidate. A candidate must name one and only one legal name.{+1}
     * - minOccurs: 0
     * @var \StructType\Candidate_Legal_Name_DataType
     */
    public $Legal_Name;
    /**
     * The Preferred_Name
     * Meta information extracted from the WSDL
     * - documentation: Contains the preferred name for a candidate. If no preferred name is returned then the legal name is assumed to be the preferred name. If a preferred name is not provided in a request then the legal name is assumed to be the
     * preferred name.
     * - minOccurs: 0
     * @var \StructType\Candidate_Preferred_Name_DataType
     */
    public $Preferred_Name;
    /**
     * Constructor method for Candidate_Name_DataType
     * @uses Candidate_Name_DataType::setLegal_Name()
     * @uses Candidate_Name_DataType::setPreferred_Name()
     * @param \StructType\Candidate_Legal_Name_DataType $legal_Name
     * @param \StructType\Candidate_Preferred_Name_DataType $preferred_Name
     */
    public function __construct(\StructType\Candidate_Legal_Name_DataType $legal_Name = null, \StructType\Candidate_Preferred_Name_DataType $preferred_Name = null)
    {
        $this
            ->setLegal_Name($legal_Name)
            ->setPreferred_Name($preferred_Name);
    }
    /**
     * Get Legal_Name value
     * @return \StructType\Candidate_Legal_Name_DataType|null
     */
    public function getLegal_Name()
    {
        return $this->Legal_Name;
    }
    /**
     * Set Legal_Name value
     * @param \StructType\Candidate_Legal_Name_DataType $legal_Name
     * @return \StructType\Candidate_Name_DataType
     */
    public function setLegal_Name(\StructType\Candidate_Legal_Name_DataType $legal_Name = null)
    {
        $this->Legal_Name = $legal_Name;
        return $this;
    }
    /**
     * Get Preferred_Name value
     * @return \StructType\Candidate_Preferred_Name_DataType|null
     */
    public function getPreferred_Name()
    {
        return $this->Preferred_Name;
    }
    /**
     * Set Preferred_Name value
     * @param \StructType\Candidate_Preferred_Name_DataType $preferred_Name
     * @return \StructType\Candidate_Name_DataType
     */
    public function setPreferred_Name(\StructType\Candidate_Preferred_Name_DataType $preferred_Name = null)
    {
        $this->Preferred_Name = $preferred_Name;
        return $this;
    }
}
