<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Identification_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Candidate Identification Data
 * @subpackage Structs
 */
class Candidate_Identification_DataType extends AbstractStructBase
{
    /**
     * The National_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\National_IDType[]
     */
    public $National_ID;
    /**
     * The Government_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Government_IDType[]
     */
    public $Government_ID;
    /**
     * Constructor method for Candidate_Identification_DataType
     * @uses Candidate_Identification_DataType::setNational_ID()
     * @uses Candidate_Identification_DataType::setGovernment_ID()
     * @param \StructType\National_IDType[] $national_ID
     * @param \StructType\Government_IDType[] $government_ID
     */
    public function __construct(array $national_ID = array(), array $government_ID = array())
    {
        $this
            ->setNational_ID($national_ID)
            ->setGovernment_ID($government_ID);
    }
    /**
     * Get National_ID value
     * @return \StructType\National_IDType[]|null
     */
    public function getNational_ID()
    {
        return $this->National_ID;
    }
    /**
     * This method is responsible for validating the values passed to the setNational_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNational_ID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNational_IDForArrayConstraintsFromSetNational_ID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Identification_DataTypeNational_IDItem) {
            // validation for constraint: itemType
            if (!$candidate_Identification_DataTypeNational_IDItem instanceof \StructType\National_IDType) {
                $invalidValues[] = is_object($candidate_Identification_DataTypeNational_IDItem) ? get_class($candidate_Identification_DataTypeNational_IDItem) : sprintf('%s(%s)', gettype($candidate_Identification_DataTypeNational_IDItem), var_export($candidate_Identification_DataTypeNational_IDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The National_ID property can only contain items of type \StructType\National_IDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set National_ID value
     * @throws \InvalidArgumentException
     * @param \StructType\National_IDType[] $national_ID
     * @return \StructType\Candidate_Identification_DataType
     */
    public function setNational_ID(array $national_ID = array())
    {
        // validation for constraint: array
        if ('' !== ($national_IDArrayErrorMessage = self::validateNational_IDForArrayConstraintsFromSetNational_ID($national_ID))) {
            throw new \InvalidArgumentException($national_IDArrayErrorMessage, __LINE__);
        }
        $this->National_ID = $national_ID;
        return $this;
    }
    /**
     * Add item to National_ID value
     * @throws \InvalidArgumentException
     * @param \StructType\National_IDType $item
     * @return \StructType\Candidate_Identification_DataType
     */
    public function addToNational_ID(\StructType\National_IDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\National_IDType) {
            throw new \InvalidArgumentException(sprintf('The National_ID property can only contain items of type \StructType\National_IDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->National_ID[] = $item;
        return $this;
    }
    /**
     * Get Government_ID value
     * @return \StructType\Government_IDType[]|null
     */
    public function getGovernment_ID()
    {
        return $this->Government_ID;
    }
    /**
     * This method is responsible for validating the values passed to the setGovernment_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGovernment_ID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGovernment_IDForArrayConstraintsFromSetGovernment_ID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Identification_DataTypeGovernment_IDItem) {
            // validation for constraint: itemType
            if (!$candidate_Identification_DataTypeGovernment_IDItem instanceof \StructType\Government_IDType) {
                $invalidValues[] = is_object($candidate_Identification_DataTypeGovernment_IDItem) ? get_class($candidate_Identification_DataTypeGovernment_IDItem) : sprintf('%s(%s)', gettype($candidate_Identification_DataTypeGovernment_IDItem), var_export($candidate_Identification_DataTypeGovernment_IDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Government_ID property can only contain items of type \StructType\Government_IDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Government_ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Government_IDType[] $government_ID
     * @return \StructType\Candidate_Identification_DataType
     */
    public function setGovernment_ID(array $government_ID = array())
    {
        // validation for constraint: array
        if ('' !== ($government_IDArrayErrorMessage = self::validateGovernment_IDForArrayConstraintsFromSetGovernment_ID($government_ID))) {
            throw new \InvalidArgumentException($government_IDArrayErrorMessage, __LINE__);
        }
        $this->Government_ID = $government_ID;
        return $this;
    }
    /**
     * Add item to Government_ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Government_IDType $item
     * @return \StructType\Candidate_Identification_DataType
     */
    public function addToGovernment_ID(\StructType\Government_IDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Government_IDType) {
            throw new \InvalidArgumentException(sprintf('The Government_ID property can only contain items of type \StructType\Government_IDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Government_ID[] = $item;
        return $this;
    }
}
