<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Experience_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the work experience for the candidate.
 * @subpackage Structs
 */
class Candidate_Experience_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing company
     * - minOccurs: 0
     * @var \StructType\Job_History_CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Company_Name
     * Meta information extracted from the WSDL
     * - documentation: Company Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company_Name;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: The business title for the work experience.
     * - maxOccurs: 1
     * @var string
     */
    public $Title;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - documentation: The location name (usually city, country region) for the work experience.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The Start_Month
     * Meta information extracted from the WSDL
     * - documentation: The start month for this work experience.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 2
     * @var float
     */
    public $Start_Month;
    /**
     * The Start_Year
     * Meta information extracted from the WSDL
     * - documentation: The start year for this work experience.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 4
     * @var float
     */
    public $Start_Year;
    /**
     * The End_Month
     * Meta information extracted from the WSDL
     * - documentation: The end month for this work experience.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 2
     * @var float
     */
    public $End_Month;
    /**
     * The End_Year
     * Meta information extracted from the WSDL
     * - documentation: The end year for this work experience.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $End_Year;
    /**
     * The Currently_Work_Here
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the candidate is currently working at this work experience.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Currently_Work_Here;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The responsibilities and achievements for this work experience.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Candidate_Experience_DataType
     * @uses Candidate_Experience_DataType::setCompany_Reference()
     * @uses Candidate_Experience_DataType::setCompany_Name()
     * @uses Candidate_Experience_DataType::setTitle()
     * @uses Candidate_Experience_DataType::setLocation()
     * @uses Candidate_Experience_DataType::setStart_Month()
     * @uses Candidate_Experience_DataType::setStart_Year()
     * @uses Candidate_Experience_DataType::setEnd_Month()
     * @uses Candidate_Experience_DataType::setEnd_Year()
     * @uses Candidate_Experience_DataType::setCurrently_Work_Here()
     * @uses Candidate_Experience_DataType::setDescription()
     * @param \StructType\Job_History_CompanyObjectType $company_Reference
     * @param string $company_Name
     * @param string $title
     * @param string $location
     * @param float $start_Month
     * @param float $start_Year
     * @param float $end_Month
     * @param float $end_Year
     * @param bool $currently_Work_Here
     * @param string $description
     */
    public function __construct(\StructType\Job_History_CompanyObjectType $company_Reference = null, $company_Name = null, $title = null, $location = null, $start_Month = null, $start_Year = null, $end_Month = null, $end_Year = null, $currently_Work_Here = null, $description = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setCompany_Name($company_Name)
            ->setTitle($title)
            ->setLocation($location)
            ->setStart_Month($start_Month)
            ->setStart_Year($start_Year)
            ->setEnd_Month($end_Month)
            ->setEnd_Year($end_Year)
            ->setCurrently_Work_Here($currently_Work_Here)
            ->setDescription($description);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\Job_History_CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\Job_History_CompanyObjectType $company_Reference
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setCompany_Reference(\StructType\Job_History_CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Company_Name value
     * @return string|null
     */
    public function getCompany_Name()
    {
        return $this->Company_Name;
    }
    /**
     * Set Company_Name value
     * @param string $company_Name
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setCompany_Name($company_Name = null)
    {
        // validation for constraint: string
        if (!is_null($company_Name) && !is_string($company_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company_Name, true), gettype($company_Name)), __LINE__);
        }
        $this->Company_Name = $company_Name;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Start_Month value
     * @return float|null
     */
    public function getStart_Month()
    {
        return $this->Start_Month;
    }
    /**
     * Set Start_Month value
     * @param float $start_Month
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setStart_Month($start_Month = null)
    {
        // validation for constraint: float
        if (!is_null($start_Month) && !(is_float($start_Month) || is_numeric($start_Month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($start_Month, true), gettype($start_Month)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($start_Month) && mb_strlen(mb_substr($start_Month, false !== mb_strpos($start_Month, '.') ? mb_strpos($start_Month, '.') + 1 : mb_strlen($start_Month))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($start_Month, true), mb_strlen(mb_substr($start_Month, mb_strpos($start_Month, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($start_Month) && $start_Month < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($start_Month, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($start_Month) && mb_strlen(preg_replace('/(\D)/', '', $start_Month)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($start_Month, true), mb_strlen(preg_replace('/(\D)/', '', $start_Month))), __LINE__);
        }
        $this->Start_Month = $start_Month;
        return $this;
    }
    /**
     * Get Start_Year value
     * @return float|null
     */
    public function getStart_Year()
    {
        return $this->Start_Year;
    }
    /**
     * Set Start_Year value
     * @param float $start_Year
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setStart_Year($start_Year = null)
    {
        // validation for constraint: float
        if (!is_null($start_Year) && !(is_float($start_Year) || is_numeric($start_Year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($start_Year, true), gettype($start_Year)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($start_Year) && mb_strlen(mb_substr($start_Year, false !== mb_strpos($start_Year, '.') ? mb_strpos($start_Year, '.') + 1 : mb_strlen($start_Year))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($start_Year, true), mb_strlen(mb_substr($start_Year, mb_strpos($start_Year, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($start_Year) && $start_Year < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($start_Year, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($start_Year) && mb_strlen(preg_replace('/(\D)/', '', $start_Year)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($start_Year, true), mb_strlen(preg_replace('/(\D)/', '', $start_Year))), __LINE__);
        }
        $this->Start_Year = $start_Year;
        return $this;
    }
    /**
     * Get End_Month value
     * @return float|null
     */
    public function getEnd_Month()
    {
        return $this->End_Month;
    }
    /**
     * Set End_Month value
     * @param float $end_Month
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setEnd_Month($end_Month = null)
    {
        // validation for constraint: float
        if (!is_null($end_Month) && !(is_float($end_Month) || is_numeric($end_Month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($end_Month, true), gettype($end_Month)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($end_Month) && mb_strlen(mb_substr($end_Month, false !== mb_strpos($end_Month, '.') ? mb_strpos($end_Month, '.') + 1 : mb_strlen($end_Month))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($end_Month, true), mb_strlen(mb_substr($end_Month, mb_strpos($end_Month, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($end_Month) && $end_Month < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($end_Month, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($end_Month) && mb_strlen(preg_replace('/(\D)/', '', $end_Month)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($end_Month, true), mb_strlen(preg_replace('/(\D)/', '', $end_Month))), __LINE__);
        }
        $this->End_Month = $end_Month;
        return $this;
    }
    /**
     * Get End_Year value
     * @return float|null
     */
    public function getEnd_Year()
    {
        return $this->End_Year;
    }
    /**
     * Set End_Year value
     * @param float $end_Year
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setEnd_Year($end_Year = null)
    {
        // validation for constraint: float
        if (!is_null($end_Year) && !(is_float($end_Year) || is_numeric($end_Year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($end_Year, true), gettype($end_Year)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($end_Year) && mb_strlen(mb_substr($end_Year, false !== mb_strpos($end_Year, '.') ? mb_strpos($end_Year, '.') + 1 : mb_strlen($end_Year))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($end_Year, true), mb_strlen(mb_substr($end_Year, mb_strpos($end_Year, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($end_Year) && $end_Year < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($end_Year, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($end_Year) && mb_strlen(preg_replace('/(\D)/', '', $end_Year)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($end_Year, true), mb_strlen(preg_replace('/(\D)/', '', $end_Year))), __LINE__);
        }
        $this->End_Year = $end_Year;
        return $this;
    }
    /**
     * Get Currently_Work_Here value
     * @return bool|null
     */
    public function getCurrently_Work_Here()
    {
        return $this->Currently_Work_Here;
    }
    /**
     * Set Currently_Work_Here value
     * @param bool $currently_Work_Here
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setCurrently_Work_Here($currently_Work_Here = null)
    {
        // validation for constraint: boolean
        if (!is_null($currently_Work_Here) && !is_bool($currently_Work_Here)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($currently_Work_Here, true), gettype($currently_Work_Here)), __LINE__);
        }
        $this->Currently_Work_Here = $currently_Work_Here;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Candidate_Experience_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
