<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Disability_Status_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for all Disability Status data for the candidate.
 * @subpackage Structs
 */
class Candidate_Disability_Status_DataType extends AbstractStructBase
{
    /**
     * The Disability_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Disability Status entry for edits and deletes.
     * - minOccurs: 0
     * @var \StructType\Disability_Status_ReferenceObjectType
     */
    public $Disability_Status_Reference;
    /**
     * The Disability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Disability status entry for edits and deletes.
     * - minOccurs: 0
     * @var \StructType\DisabilityObjectType
     */
    public $Disability_Reference;
    /**
     * The Disability_Status_Date
     * Meta information extracted from the WSDL
     * - documentation: This candidate's disability status date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Disability_Status_Date;
    /**
     * Constructor method for Candidate_Disability_Status_DataType
     * @uses Candidate_Disability_Status_DataType::setDisability_Status_Reference()
     * @uses Candidate_Disability_Status_DataType::setDisability_Reference()
     * @uses Candidate_Disability_Status_DataType::setDisability_Status_Date()
     * @param \StructType\Disability_Status_ReferenceObjectType $disability_Status_Reference
     * @param \StructType\DisabilityObjectType $disability_Reference
     * @param string $disability_Status_Date
     */
    public function __construct(\StructType\Disability_Status_ReferenceObjectType $disability_Status_Reference = null, \StructType\DisabilityObjectType $disability_Reference = null, $disability_Status_Date = null)
    {
        $this
            ->setDisability_Status_Reference($disability_Status_Reference)
            ->setDisability_Reference($disability_Reference)
            ->setDisability_Status_Date($disability_Status_Date);
    }
    /**
     * Get Disability_Status_Reference value
     * @return \StructType\Disability_Status_ReferenceObjectType|null
     */
    public function getDisability_Status_Reference()
    {
        return $this->Disability_Status_Reference;
    }
    /**
     * Set Disability_Status_Reference value
     * @param \StructType\Disability_Status_ReferenceObjectType $disability_Status_Reference
     * @return \StructType\Candidate_Disability_Status_DataType
     */
    public function setDisability_Status_Reference(\StructType\Disability_Status_ReferenceObjectType $disability_Status_Reference = null)
    {
        $this->Disability_Status_Reference = $disability_Status_Reference;
        return $this;
    }
    /**
     * Get Disability_Reference value
     * @return \StructType\DisabilityObjectType|null
     */
    public function getDisability_Reference()
    {
        return $this->Disability_Reference;
    }
    /**
     * Set Disability_Reference value
     * @param \StructType\DisabilityObjectType $disability_Reference
     * @return \StructType\Candidate_Disability_Status_DataType
     */
    public function setDisability_Reference(\StructType\DisabilityObjectType $disability_Reference = null)
    {
        $this->Disability_Reference = $disability_Reference;
        return $this;
    }
    /**
     * Get Disability_Status_Date value
     * @return string|null
     */
    public function getDisability_Status_Date()
    {
        return $this->Disability_Status_Date;
    }
    /**
     * Set Disability_Status_Date value
     * @param string $disability_Status_Date
     * @return \StructType\Candidate_Disability_Status_DataType
     */
    public function setDisability_Status_Date($disability_Status_Date = null)
    {
        // validation for constraint: string
        if (!is_null($disability_Status_Date) && !is_string($disability_Status_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disability_Status_Date, true), gettype($disability_Status_Date)), __LINE__);
        }
        $this->Disability_Status_Date = $disability_Status_Date;
        return $this;
    }
}
