<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Certification_Skill_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Certification information.
 * @subpackage Structs
 */
class Candidate_Certification_Skill_DataType extends AbstractStructBase
{
    /**
     * The Certification_Skill_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the certification profile.
     * - minOccurs: 0
     * @var \StructType\Certification_QualificationObjectType
     */
    public $Certification_Skill_Reference;
    /**
     * The Certification_Data_Details
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Certification data.
     * - maxOccurs: unbounded
     * @var \StructType\Candidate_Certification_DataType[]
     */
    public $Certification_Data_Details;
    /**
     * Constructor method for Candidate_Certification_Skill_DataType
     * @uses Candidate_Certification_Skill_DataType::setCertification_Skill_Reference()
     * @uses Candidate_Certification_Skill_DataType::setCertification_Data_Details()
     * @param \StructType\Certification_QualificationObjectType $certification_Skill_Reference
     * @param \StructType\Candidate_Certification_DataType[] $certification_Data_Details
     */
    public function __construct(\StructType\Certification_QualificationObjectType $certification_Skill_Reference = null, array $certification_Data_Details = array())
    {
        $this
            ->setCertification_Skill_Reference($certification_Skill_Reference)
            ->setCertification_Data_Details($certification_Data_Details);
    }
    /**
     * Get Certification_Skill_Reference value
     * @return \StructType\Certification_QualificationObjectType|null
     */
    public function getCertification_Skill_Reference()
    {
        return $this->Certification_Skill_Reference;
    }
    /**
     * Set Certification_Skill_Reference value
     * @param \StructType\Certification_QualificationObjectType $certification_Skill_Reference
     * @return \StructType\Candidate_Certification_Skill_DataType
     */
    public function setCertification_Skill_Reference(\StructType\Certification_QualificationObjectType $certification_Skill_Reference = null)
    {
        $this->Certification_Skill_Reference = $certification_Skill_Reference;
        return $this;
    }
    /**
     * Get Certification_Data_Details value
     * @return \StructType\Candidate_Certification_DataType[]|null
     */
    public function getCertification_Data_Details()
    {
        return $this->Certification_Data_Details;
    }
    /**
     * This method is responsible for validating the values passed to the setCertification_Data_Details method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertification_Data_Details method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertification_Data_DetailsForArrayConstraintsFromSetCertification_Data_Details(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Certification_Skill_DataTypeCertification_Data_DetailsItem) {
            // validation for constraint: itemType
            if (!$candidate_Certification_Skill_DataTypeCertification_Data_DetailsItem instanceof \StructType\Candidate_Certification_DataType) {
                $invalidValues[] = is_object($candidate_Certification_Skill_DataTypeCertification_Data_DetailsItem) ? get_class($candidate_Certification_Skill_DataTypeCertification_Data_DetailsItem) : sprintf('%s(%s)', gettype($candidate_Certification_Skill_DataTypeCertification_Data_DetailsItem), var_export($candidate_Certification_Skill_DataTypeCertification_Data_DetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Certification_Data_Details property can only contain items of type \StructType\Candidate_Certification_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Certification_Data_Details value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Certification_DataType[] $certification_Data_Details
     * @return \StructType\Candidate_Certification_Skill_DataType
     */
    public function setCertification_Data_Details(array $certification_Data_Details = array())
    {
        // validation for constraint: array
        if ('' !== ($certification_Data_DetailsArrayErrorMessage = self::validateCertification_Data_DetailsForArrayConstraintsFromSetCertification_Data_Details($certification_Data_Details))) {
            throw new \InvalidArgumentException($certification_Data_DetailsArrayErrorMessage, __LINE__);
        }
        $this->Certification_Data_Details = $certification_Data_Details;
        return $this;
    }
    /**
     * Add item to Certification_Data_Details value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Certification_DataType $item
     * @return \StructType\Candidate_Certification_Skill_DataType
     */
    public function addToCertification_Data_Details(\StructType\Candidate_Certification_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Certification_DataType) {
            throw new \InvalidArgumentException(sprintf('The Certification_Data_Details property can only contain items of type \StructType\Candidate_Certification_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Certification_Data_Details[] = $item;
        return $this;
    }
}
