<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brand_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request Criteria element to filter instances of site brands. These attributes and references help you find data outside of Workday IDs and Lookup IDs within the Request_References element.
 * @subpackage Structs
 */
class Brand_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Prioritize_Drafts
     * Meta information extracted from the WSDL
     * - documentation: Returns the latest draft, or returns the published version if no draft is available.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prioritize_Drafts;
    /**
     * Constructor method for Brand_Request_CriteriaType
     * @uses Brand_Request_CriteriaType::setPrioritize_Drafts()
     * @param bool $prioritize_Drafts
     */
    public function __construct($prioritize_Drafts = null)
    {
        $this
            ->setPrioritize_Drafts($prioritize_Drafts);
    }
    /**
     * Get Prioritize_Drafts value
     * @return bool|null
     */
    public function getPrioritize_Drafts()
    {
        return $this->Prioritize_Drafts;
    }
    /**
     * Set Prioritize_Drafts value
     * @param bool $prioritize_Drafts
     * @return \StructType\Brand_Request_CriteriaType
     */
    public function setPrioritize_Drafts($prioritize_Drafts = null)
    {
        // validation for constraint: boolean
        if (!is_null($prioritize_Drafts) && !is_bool($prioritize_Drafts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prioritize_Drafts, true), gettype($prioritize_Drafts)), __LINE__);
        }
        $this->Prioritize_Drafts = $prioritize_Drafts;
        return $this;
    }
}
