<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for Background Check Events. Used for Background Check Events that have Background Check Packages.
 * @subpackage Structs
 */
class Background_Check_Response_DataType extends AbstractStructBase
{
    /**
     * The Background_Check_Event
     * Meta information extracted from the WSDL
     * - documentation: Details for a Background Check Event
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Background_Check_EventType[]
     */
    public $Background_Check_Event;
    /**
     * Constructor method for Background_Check_Response_DataType
     * @uses Background_Check_Response_DataType::setBackground_Check_Event()
     * @param \StructType\Background_Check_EventType[] $background_Check_Event
     */
    public function __construct(array $background_Check_Event = array())
    {
        $this
            ->setBackground_Check_Event($background_Check_Event);
    }
    /**
     * Get Background_Check_Event value
     * @return \StructType\Background_Check_EventType[]|null
     */
    public function getBackground_Check_Event()
    {
        return $this->Background_Check_Event;
    }
    /**
     * This method is responsible for validating the values passed to the setBackground_Check_Event method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBackground_Check_Event method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBackground_Check_EventForArrayConstraintsFromSetBackground_Check_Event(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_Response_DataTypeBackground_Check_EventItem) {
            // validation for constraint: itemType
            if (!$background_Check_Response_DataTypeBackground_Check_EventItem instanceof \StructType\Background_Check_EventType) {
                $invalidValues[] = is_object($background_Check_Response_DataTypeBackground_Check_EventItem) ? get_class($background_Check_Response_DataTypeBackground_Check_EventItem) : sprintf('%s(%s)', gettype($background_Check_Response_DataTypeBackground_Check_EventItem), var_export($background_Check_Response_DataTypeBackground_Check_EventItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Background_Check_Event property can only contain items of type \StructType\Background_Check_EventType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Background_Check_Event value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_EventType[] $background_Check_Event
     * @return \StructType\Background_Check_Response_DataType
     */
    public function setBackground_Check_Event(array $background_Check_Event = array())
    {
        // validation for constraint: array
        if ('' !== ($background_Check_EventArrayErrorMessage = self::validateBackground_Check_EventForArrayConstraintsFromSetBackground_Check_Event($background_Check_Event))) {
            throw new \InvalidArgumentException($background_Check_EventArrayErrorMessage, __LINE__);
        }
        $this->Background_Check_Event = $background_Check_Event;
        return $this;
    }
    /**
     * Add item to Background_Check_Event value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_EventType $item
     * @return \StructType\Background_Check_Response_DataType
     */
    public function addToBackground_Check_Event(\StructType\Background_Check_EventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Background_Check_EventType) {
            throw new \InvalidArgumentException(sprintf('The Background_Check_Event property can only contain items of type \StructType\Background_Check_EventType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Background_Check_Event[] = $item;
        return $this;
    }
}
