<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Background Check Event request references.
 * @subpackage Structs
 */
class Background_Check_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Background Check Event request references.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Background_Check_EventObjectType[]
     */
    public $Event_Reference;
    /**
     * Constructor method for Background_Check_Request_ReferencesType
     * @uses Background_Check_Request_ReferencesType::setEvent_Reference()
     * @param \StructType\Background_Check_EventObjectType[] $event_Reference
     */
    public function __construct(array $event_Reference = array())
    {
        $this
            ->setEvent_Reference($event_Reference);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Background_Check_EventObjectType[]|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEvent_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvent_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEvent_ReferenceForArrayConstraintsFromSetEvent_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_Request_ReferencesTypeEvent_ReferenceItem) {
            // validation for constraint: itemType
            if (!$background_Check_Request_ReferencesTypeEvent_ReferenceItem instanceof \StructType\Background_Check_EventObjectType) {
                $invalidValues[] = is_object($background_Check_Request_ReferencesTypeEvent_ReferenceItem) ? get_class($background_Check_Request_ReferencesTypeEvent_ReferenceItem) : sprintf('%s(%s)', gettype($background_Check_Request_ReferencesTypeEvent_ReferenceItem), var_export($background_Check_Request_ReferencesTypeEvent_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Event_Reference property can only contain items of type \StructType\Background_Check_EventObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Event_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_EventObjectType[] $event_Reference
     * @return \StructType\Background_Check_Request_ReferencesType
     */
    public function setEvent_Reference(array $event_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($event_ReferenceArrayErrorMessage = self::validateEvent_ReferenceForArrayConstraintsFromSetEvent_Reference($event_Reference))) {
            throw new \InvalidArgumentException($event_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Add item to Event_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_EventObjectType $item
     * @return \StructType\Background_Check_Request_ReferencesType
     */
    public function addToEvent_Reference(\StructType\Background_Check_EventObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Background_Check_EventObjectType) {
            throw new \InvalidArgumentException(sprintf('The Event_Reference property can only contain items of type \StructType\Background_Check_EventObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Event_Reference[] = $item;
        return $this;
    }
}
