<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Background Check data.
 * @subpackage Structs
 */
class Background_Check_DataType extends AbstractStructBase
{
    /**
     * The Recipient_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a candidate, worker, or pre-hire.
     * - choice: Recipient_Reference | Event_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RoleObjectType
     */
    public $Recipient_Reference;
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Background Check Event.
     * - choice: Recipient_Reference | Event_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Background_Check_EventObjectType
     */
    public $Event_Reference;
    /**
     * The Background_Check_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Background Check Event.
     * - minOccurs: 0
     * @var \StructType\Background_Check_Overall_Status_DataType
     */
    public $Background_Check_Status_Data;
    /**
     * The Package_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for the Background Check Package results.
     * - minOccurs: 0
     * @var \StructType\Package_Reference_DataType
     */
    public $Package_Reference_Data;
    /**
     * The Test_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for results of each Background Check Package Test.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Test_Reference_DataType[]
     */
    public $Test_Reference_Data;
    /**
     * Constructor method for Background_Check_DataType
     * @uses Background_Check_DataType::setRecipient_Reference()
     * @uses Background_Check_DataType::setEvent_Reference()
     * @uses Background_Check_DataType::setBackground_Check_Status_Data()
     * @uses Background_Check_DataType::setPackage_Reference_Data()
     * @uses Background_Check_DataType::setTest_Reference_Data()
     * @param \StructType\RoleObjectType $recipient_Reference
     * @param \StructType\Background_Check_EventObjectType $event_Reference
     * @param \StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data
     * @param \StructType\Package_Reference_DataType $package_Reference_Data
     * @param \StructType\Test_Reference_DataType[] $test_Reference_Data
     */
    public function __construct(\StructType\RoleObjectType $recipient_Reference = null, \StructType\Background_Check_EventObjectType $event_Reference = null, \StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data = null, \StructType\Package_Reference_DataType $package_Reference_Data = null, array $test_Reference_Data = array())
    {
        $this
            ->setRecipient_Reference($recipient_Reference)
            ->setEvent_Reference($event_Reference)
            ->setBackground_Check_Status_Data($background_Check_Status_Data)
            ->setPackage_Reference_Data($package_Reference_Data)
            ->setTest_Reference_Data($test_Reference_Data);
    }
    /**
     * Get Recipient_Reference value
     * @return \StructType\RoleObjectType|null
     */
    public function getRecipient_Reference()
    {
        return isset($this->Recipient_Reference) ? $this->Recipient_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRecipient_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipient_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRecipient_ReferenceForChoiceConstraintsFromSetRecipient_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Event_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Recipient_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Recipient_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Recipient_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoleObjectType $recipient_Reference
     * @return \StructType\Background_Check_DataType
     */
    public function setRecipient_Reference(\StructType\RoleObjectType $recipient_Reference = null)
    {
        // validation for constraint: choice(Recipient_Reference, Event_Reference)
        if ('' !== ($recipient_ReferenceChoiceErrorMessage = self::validateRecipient_ReferenceForChoiceConstraintsFromSetRecipient_Reference($recipient_Reference))) {
            throw new \InvalidArgumentException($recipient_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($recipient_Reference) || (is_array($recipient_Reference) && empty($recipient_Reference))) {
            unset($this->Recipient_Reference);
        } else {
            $this->Recipient_Reference = $recipient_Reference;
        }
        return $this;
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Background_Check_EventObjectType|null
     */
    public function getEvent_Reference()
    {
        return isset($this->Event_Reference) ? $this->Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEvent_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvent_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEvent_ReferenceForChoiceConstraintsFromSetEvent_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Recipient_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_EventObjectType $event_Reference
     * @return \StructType\Background_Check_DataType
     */
    public function setEvent_Reference(\StructType\Background_Check_EventObjectType $event_Reference = null)
    {
        // validation for constraint: choice(Recipient_Reference, Event_Reference)
        if ('' !== ($event_ReferenceChoiceErrorMessage = self::validateEvent_ReferenceForChoiceConstraintsFromSetEvent_Reference($event_Reference))) {
            throw new \InvalidArgumentException($event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($event_Reference) || (is_array($event_Reference) && empty($event_Reference))) {
            unset($this->Event_Reference);
        } else {
            $this->Event_Reference = $event_Reference;
        }
        return $this;
    }
    /**
     * Get Background_Check_Status_Data value
     * @return \StructType\Background_Check_Overall_Status_DataType|null
     */
    public function getBackground_Check_Status_Data()
    {
        return $this->Background_Check_Status_Data;
    }
    /**
     * Set Background_Check_Status_Data value
     * @param \StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data
     * @return \StructType\Background_Check_DataType
     */
    public function setBackground_Check_Status_Data(\StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data = null)
    {
        $this->Background_Check_Status_Data = $background_Check_Status_Data;
        return $this;
    }
    /**
     * Get Package_Reference_Data value
     * @return \StructType\Package_Reference_DataType|null
     */
    public function getPackage_Reference_Data()
    {
        return $this->Package_Reference_Data;
    }
    /**
     * Set Package_Reference_Data value
     * @param \StructType\Package_Reference_DataType $package_Reference_Data
     * @return \StructType\Background_Check_DataType
     */
    public function setPackage_Reference_Data(\StructType\Package_Reference_DataType $package_Reference_Data = null)
    {
        $this->Package_Reference_Data = $package_Reference_Data;
        return $this;
    }
    /**
     * Get Test_Reference_Data value
     * @return \StructType\Test_Reference_DataType[]|null
     */
    public function getTest_Reference_Data()
    {
        return $this->Test_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTest_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTest_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTest_Reference_DataForArrayConstraintsFromSetTest_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_DataTypeTest_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$background_Check_DataTypeTest_Reference_DataItem instanceof \StructType\Test_Reference_DataType) {
                $invalidValues[] = is_object($background_Check_DataTypeTest_Reference_DataItem) ? get_class($background_Check_DataTypeTest_Reference_DataItem) : sprintf('%s(%s)', gettype($background_Check_DataTypeTest_Reference_DataItem), var_export($background_Check_DataTypeTest_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Test_Reference_Data property can only contain items of type \StructType\Test_Reference_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Test_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Test_Reference_DataType[] $test_Reference_Data
     * @return \StructType\Background_Check_DataType
     */
    public function setTest_Reference_Data(array $test_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($test_Reference_DataArrayErrorMessage = self::validateTest_Reference_DataForArrayConstraintsFromSetTest_Reference_Data($test_Reference_Data))) {
            throw new \InvalidArgumentException($test_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Test_Reference_Data = $test_Reference_Data;
        return $this;
    }
    /**
     * Add item to Test_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Test_Reference_DataType $item
     * @return \StructType\Background_Check_DataType
     */
    public function addToTest_Reference_Data(\StructType\Test_Reference_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Test_Reference_DataType) {
            throw new \InvalidArgumentException(sprintf('The Test_Reference_Data property can only contain items of type \StructType\Test_Reference_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Test_Reference_Data[] = $item;
        return $this;
    }
}
