<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Recruiting_Self-Schedule_Calendar_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Top level request for assigning recruiting self-schedule event calendars to job requisitions.
 * @subpackage Structs
 */
class Assign_Recruiting_Self_Schedule_Calendar_RequestType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the job requisition. If left blank, the web service will try to fill this with the job requisition entered in the Job Requisition Reference ID field.
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Assign_Recruiting_Self_Schedule_Calendar_Data
     * Meta information extracted from the WSDL
     * - documentation: This holds the calendar assignment data.
     * @var \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType
     */
    public $Assign_Recruiting_Self_Schedule_Calendar_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Assign_Recruiting_Self-Schedule_Calendar_RequestType
     * @uses Assign_Recruiting_Self_Schedule_Calendar_RequestType::setJob_Requisition_Reference()
     * @uses Assign_Recruiting_Self_Schedule_Calendar_RequestType::setAssign_Recruiting_Self_Schedule_Calendar_Data()
     * @uses Assign_Recruiting_Self_Schedule_Calendar_RequestType::setVersion()
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType $assign_Recruiting_Self_Schedule_Calendar_Data
     * @param string $version
     */
    public function __construct(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType $assign_Recruiting_Self_Schedule_Calendar_Data = null, $version = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setAssign_Recruiting_Self_Schedule_Calendar_Data($assign_Recruiting_Self_Schedule_Calendar_Data)
            ->setVersion($version);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendar_RequestType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Assign_Recruiting_Self_Schedule_Calendar_Data value
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType|null
     */
    public function getAssign_Recruiting_Self_Schedule_Calendar_Data()
    {
        return $this->{'Assign_Recruiting_Self-Schedule_Calendar_Data'};
    }
    /**
     * Set Assign_Recruiting_Self_Schedule_Calendar_Data value
     * @param \StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType $assign_Recruiting_Self_Schedule_Calendar_Data
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendar_RequestType
     */
    public function setAssign_Recruiting_Self_Schedule_Calendar_Data(\StructType\Assign_Recruiting_Self_Schedule_Calendars_DataType $assign_Recruiting_Self_Schedule_Calendar_Data = null)
    {
        $this->Assign_Recruiting_Self_Schedule_Calendar_Data = $this->{'Assign_Recruiting_Self-Schedule_Calendar_Data'} = $assign_Recruiting_Self_Schedule_Calendar_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Assign_Recruiting_Self_Schedule_Calendar_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
