<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Employee_Collective_Agreement_Sub_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Assign Employee Collective Agreement event used as a sub bp.
 * @subpackage Structs
 */
class Assign_Employee_Collective_Agreement_Sub_DataType extends AbstractStructBase
{
    /**
     * The Collective_Agreement_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Collective Agreement ID.
     * @var \StructType\Collective_AgreementObjectType
     */
    public $Collective_Agreement_Reference;
    /**
     * The Factor_Options
     * Meta information extracted from the WSDL
     * - documentation: Wrapper for collective agreement factors and factor options.
     * - minOccurs: 0
     * @var \StructType\Collective_Agreement_Factor_Options_DataType
     */
    public $Factor_Options;
    /**
     * Constructor method for Assign_Employee_Collective_Agreement_Sub_DataType
     * @uses Assign_Employee_Collective_Agreement_Sub_DataType::setCollective_Agreement_Reference()
     * @uses Assign_Employee_Collective_Agreement_Sub_DataType::setFactor_Options()
     * @param \StructType\Collective_AgreementObjectType $collective_Agreement_Reference
     * @param \StructType\Collective_Agreement_Factor_Options_DataType $factor_Options
     */
    public function __construct(\StructType\Collective_AgreementObjectType $collective_Agreement_Reference = null, \StructType\Collective_Agreement_Factor_Options_DataType $factor_Options = null)
    {
        $this
            ->setCollective_Agreement_Reference($collective_Agreement_Reference)
            ->setFactor_Options($factor_Options);
    }
    /**
     * Get Collective_Agreement_Reference value
     * @return \StructType\Collective_AgreementObjectType|null
     */
    public function getCollective_Agreement_Reference()
    {
        return $this->Collective_Agreement_Reference;
    }
    /**
     * Set Collective_Agreement_Reference value
     * @param \StructType\Collective_AgreementObjectType $collective_Agreement_Reference
     * @return \StructType\Assign_Employee_Collective_Agreement_Sub_DataType
     */
    public function setCollective_Agreement_Reference(\StructType\Collective_AgreementObjectType $collective_Agreement_Reference = null)
    {
        $this->Collective_Agreement_Reference = $collective_Agreement_Reference;
        return $this;
    }
    /**
     * Get Factor_Options value
     * @return \StructType\Collective_Agreement_Factor_Options_DataType|null
     */
    public function getFactor_Options()
    {
        return $this->Factor_Options;
    }
    /**
     * Set Factor_Options value
     * @param \StructType\Collective_Agreement_Factor_Options_DataType $factor_Options
     * @return \StructType\Assign_Employee_Collective_Agreement_Sub_DataType
     */
    public function setFactor_Options(\StructType\Collective_Agreement_Factor_Options_DataType $factor_Options = null)
    {
        $this->Factor_Options = $factor_Options;
        return $this;
    }
}
