<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assess_Candidate_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: The result of an attempt to create or modify a Candidate Assessment.
 * @subpackage Structs
 */
class Assess_Candidate_ResponseType extends AbstractStructBase
{
    /**
     * The Candidate_Assessment_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the modified or created Candidate Assessment Event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Candidate_Assessment_Event_Reference;
    /**
     * The Candidate_Assessment_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the modified or created Candidate Assessment.
     * - minOccurs: 0
     * @var \StructType\Recruiting_AssessmentObjectType
     */
    public $Candidate_Assessment_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Assess_Candidate_ResponseType
     * @uses Assess_Candidate_ResponseType::setCandidate_Assessment_Event_Reference()
     * @uses Assess_Candidate_ResponseType::setCandidate_Assessment_Reference()
     * @uses Assess_Candidate_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $candidate_Assessment_Event_Reference
     * @param \StructType\Recruiting_AssessmentObjectType $candidate_Assessment_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $candidate_Assessment_Event_Reference = null, \StructType\Recruiting_AssessmentObjectType $candidate_Assessment_Reference = null, $version = null)
    {
        $this
            ->setCandidate_Assessment_Event_Reference($candidate_Assessment_Event_Reference)
            ->setCandidate_Assessment_Reference($candidate_Assessment_Reference)
            ->setVersion($version);
    }
    /**
     * Get Candidate_Assessment_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getCandidate_Assessment_Event_Reference()
    {
        return $this->Candidate_Assessment_Event_Reference;
    }
    /**
     * Set Candidate_Assessment_Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $candidate_Assessment_Event_Reference
     * @return \StructType\Assess_Candidate_ResponseType
     */
    public function setCandidate_Assessment_Event_Reference(\StructType\Unique_IdentifierObjectType $candidate_Assessment_Event_Reference = null)
    {
        $this->Candidate_Assessment_Event_Reference = $candidate_Assessment_Event_Reference;
        return $this;
    }
    /**
     * Get Candidate_Assessment_Reference value
     * @return \StructType\Recruiting_AssessmentObjectType|null
     */
    public function getCandidate_Assessment_Reference()
    {
        return $this->Candidate_Assessment_Reference;
    }
    /**
     * Set Candidate_Assessment_Reference value
     * @param \StructType\Recruiting_AssessmentObjectType $candidate_Assessment_Reference
     * @return \StructType\Assess_Candidate_ResponseType
     */
    public function setCandidate_Assessment_Reference(\StructType\Recruiting_AssessmentObjectType $candidate_Assessment_Reference = null)
    {
        $this->Candidate_Assessment_Reference = $candidate_Assessment_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Assess_Candidate_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
