<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicant_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing the list of applicant information to be included in the response.
 * @subpackage Structs
 */
class Applicant_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Reference element for the applicant is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Personal_Information
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Personal Data element is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Personal_Information;
    /**
     * The Show_All_Personal_Information
     * Meta information extracted from the WSDL
     * - documentation: Show All Personal Information by Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Show_All_Personal_Information;
    /**
     * The Include_Recruiting_Information
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Recruiting Data element is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Recruiting_Information;
    /**
     * The Include_Qualification_Profile
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Qualification Data element (Accomplishment, External Employment, Competency, Certification, Training, Award, Organization Membership, Education,, Work Experience ) is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Qualification_Profile;
    /**
     * The Include_Resume
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Resume Data element is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Resume;
    /**
     * The Include_Background_Check
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Background Check Data element is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Background_Check;
    /**
     * The Include_External_Integration_ID_Data
     * Meta information extracted from the WSDL
     * - documentation: A flag to indicate if external integration id should be included.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_External_Integration_ID_Data;
    /**
     * Constructor method for Applicant_Response_GroupType
     * @uses Applicant_Response_GroupType::setInclude_Reference()
     * @uses Applicant_Response_GroupType::setInclude_Personal_Information()
     * @uses Applicant_Response_GroupType::setShow_All_Personal_Information()
     * @uses Applicant_Response_GroupType::setInclude_Recruiting_Information()
     * @uses Applicant_Response_GroupType::setInclude_Qualification_Profile()
     * @uses Applicant_Response_GroupType::setInclude_Resume()
     * @uses Applicant_Response_GroupType::setInclude_Background_Check()
     * @uses Applicant_Response_GroupType::setInclude_External_Integration_ID_Data()
     * @param bool $include_Reference
     * @param bool $include_Personal_Information
     * @param bool $show_All_Personal_Information
     * @param bool $include_Recruiting_Information
     * @param bool $include_Qualification_Profile
     * @param bool $include_Resume
     * @param bool $include_Background_Check
     * @param bool $include_External_Integration_ID_Data
     */
    public function __construct($include_Reference = null, $include_Personal_Information = null, $show_All_Personal_Information = null, $include_Recruiting_Information = null, $include_Qualification_Profile = null, $include_Resume = null, $include_Background_Check = null, $include_External_Integration_ID_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Personal_Information($include_Personal_Information)
            ->setShow_All_Personal_Information($show_All_Personal_Information)
            ->setInclude_Recruiting_Information($include_Recruiting_Information)
            ->setInclude_Qualification_Profile($include_Qualification_Profile)
            ->setInclude_Resume($include_Resume)
            ->setInclude_Background_Check($include_Background_Check)
            ->setInclude_External_Integration_ID_Data($include_External_Integration_ID_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Personal_Information value
     * @return bool|null
     */
    public function getInclude_Personal_Information()
    {
        return $this->Include_Personal_Information;
    }
    /**
     * Set Include_Personal_Information value
     * @param bool $include_Personal_Information
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_Personal_Information($include_Personal_Information = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Personal_Information) && !is_bool($include_Personal_Information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Personal_Information, true), gettype($include_Personal_Information)), __LINE__);
        }
        $this->Include_Personal_Information = $include_Personal_Information;
        return $this;
    }
    /**
     * Get Show_All_Personal_Information value
     * @return bool|null
     */
    public function getShow_All_Personal_Information()
    {
        return $this->Show_All_Personal_Information;
    }
    /**
     * Set Show_All_Personal_Information value
     * @param bool $show_All_Personal_Information
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setShow_All_Personal_Information($show_All_Personal_Information = null)
    {
        // validation for constraint: boolean
        if (!is_null($show_All_Personal_Information) && !is_bool($show_All_Personal_Information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($show_All_Personal_Information, true), gettype($show_All_Personal_Information)), __LINE__);
        }
        $this->Show_All_Personal_Information = $show_All_Personal_Information;
        return $this;
    }
    /**
     * Get Include_Recruiting_Information value
     * @return bool|null
     */
    public function getInclude_Recruiting_Information()
    {
        return $this->Include_Recruiting_Information;
    }
    /**
     * Set Include_Recruiting_Information value
     * @param bool $include_Recruiting_Information
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_Recruiting_Information($include_Recruiting_Information = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Recruiting_Information) && !is_bool($include_Recruiting_Information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Recruiting_Information, true), gettype($include_Recruiting_Information)), __LINE__);
        }
        $this->Include_Recruiting_Information = $include_Recruiting_Information;
        return $this;
    }
    /**
     * Get Include_Qualification_Profile value
     * @return bool|null
     */
    public function getInclude_Qualification_Profile()
    {
        return $this->Include_Qualification_Profile;
    }
    /**
     * Set Include_Qualification_Profile value
     * @param bool $include_Qualification_Profile
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_Qualification_Profile($include_Qualification_Profile = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Qualification_Profile) && !is_bool($include_Qualification_Profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Qualification_Profile, true), gettype($include_Qualification_Profile)), __LINE__);
        }
        $this->Include_Qualification_Profile = $include_Qualification_Profile;
        return $this;
    }
    /**
     * Get Include_Resume value
     * @return bool|null
     */
    public function getInclude_Resume()
    {
        return $this->Include_Resume;
    }
    /**
     * Set Include_Resume value
     * @param bool $include_Resume
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_Resume($include_Resume = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Resume) && !is_bool($include_Resume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Resume, true), gettype($include_Resume)), __LINE__);
        }
        $this->Include_Resume = $include_Resume;
        return $this;
    }
    /**
     * Get Include_Background_Check value
     * @return bool|null
     */
    public function getInclude_Background_Check()
    {
        return $this->Include_Background_Check;
    }
    /**
     * Set Include_Background_Check value
     * @param bool $include_Background_Check
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_Background_Check($include_Background_Check = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Background_Check) && !is_bool($include_Background_Check)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Background_Check, true), gettype($include_Background_Check)), __LINE__);
        }
        $this->Include_Background_Check = $include_Background_Check;
        return $this;
    }
    /**
     * Get Include_External_Integration_ID_Data value
     * @return bool|null
     */
    public function getInclude_External_Integration_ID_Data()
    {
        return $this->Include_External_Integration_ID_Data;
    }
    /**
     * Set Include_External_Integration_ID_Data value
     * @param bool $include_External_Integration_ID_Data
     * @return \StructType\Applicant_Response_GroupType
     */
    public function setInclude_External_Integration_ID_Data($include_External_Integration_ID_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_External_Integration_ID_Data) && !is_bool($include_External_Integration_ID_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_External_Integration_ID_Data, true), gettype($include_External_Integration_ID_Data)), __LINE__);
        }
        $this->Include_External_Integration_ID_Data = $include_External_Integration_ID_Data;
        return $this;
    }
}
