<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Additional_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the additional names for a person, other than their legal and preferred names. Additional names are not valid for applicants.
 * @subpackage Structs
 */
class Additional_Name_DataType extends AbstractStructBase
{
    /**
     * The Name_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the components of a name, such as the First Name and Last Name.
     * @var \StructType\Person_Name_Detail_DataType
     */
    public $Name_Detail_Data;
    /**
     * The Name_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The type of Additional Name that the name is.
     * - minOccurs: 0
     * @var \StructType\Additional_Name_TypeObjectType
     */
    public $Name_Type_Reference;
    /**
     * Constructor method for Additional_Name_DataType
     * @uses Additional_Name_DataType::setName_Detail_Data()
     * @uses Additional_Name_DataType::setName_Type_Reference()
     * @param \StructType\Person_Name_Detail_DataType $name_Detail_Data
     * @param \StructType\Additional_Name_TypeObjectType $name_Type_Reference
     */
    public function __construct(\StructType\Person_Name_Detail_DataType $name_Detail_Data = null, \StructType\Additional_Name_TypeObjectType $name_Type_Reference = null)
    {
        $this
            ->setName_Detail_Data($name_Detail_Data)
            ->setName_Type_Reference($name_Type_Reference);
    }
    /**
     * Get Name_Detail_Data value
     * @return \StructType\Person_Name_Detail_DataType|null
     */
    public function getName_Detail_Data()
    {
        return $this->Name_Detail_Data;
    }
    /**
     * Set Name_Detail_Data value
     * @param \StructType\Person_Name_Detail_DataType $name_Detail_Data
     * @return \StructType\Additional_Name_DataType
     */
    public function setName_Detail_Data(\StructType\Person_Name_Detail_DataType $name_Detail_Data = null)
    {
        $this->Name_Detail_Data = $name_Detail_Data;
        return $this;
    }
    /**
     * Get Name_Type_Reference value
     * @return \StructType\Additional_Name_TypeObjectType|null
     */
    public function getName_Type_Reference()
    {
        return $this->Name_Type_Reference;
    }
    /**
     * Set Name_Type_Reference value
     * @param \StructType\Additional_Name_TypeObjectType $name_Type_Reference
     * @return \StructType\Additional_Name_DataType
     */
    public function setName_Type_Reference(\StructType\Additional_Name_TypeObjectType $name_Type_Reference = null)
    {
        $this->Name_Type_Reference = $name_Type_Reference;
        return $this;
    }
}
