<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Edit ServiceType
 * @subpackage Services
 */
class Edit extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Edit_Position_Restrictions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Edits an existing position restriction. Uses the Edit Position Restrictions business process.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Edit_Position_Restrictions_RequestType $body
     * @return \StructType\Edit_Positon_Restriction_ResponseType|bool
     */
    public function Edit_Position_Restrictions(\StructType\Edit_Position_Restrictions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Edit_Position_Restrictions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Edit_Job_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will edit an existing job requisition. The job requisition must be open.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Edit_Job_Requisition_RequestType $body
     * @return \StructType\Edit_Job_Requisition_ResponseType|bool
     */
    public function Edit_Job_Requisition(\StructType\Edit_Job_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Edit_Job_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Edit_Evergreen_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will edit an evergreen job requisition.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Edit_Evergreen_Requisition_RequestType $body
     * @return \StructType\Edit_Evergreen_Requisition_ResponseType|bool
     */
    public function Edit_Evergreen_Requisition(\StructType\Edit_Evergreen_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Edit_Evergreen_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Edit_Position_Restrictions_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Allows updating of effective-dated custom objects for position restrictions. When updating custom objects that allow multiple instances, data for existing instances must appear in the request, otherwise it will be removed.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Edit_Position_Restrictions_Additional_Data_RequestType $body
     * @return \StructType\Edit_Position_Restrictions_Additional_Data_ResponseType|bool
     */
    public function Edit_Position_Restrictions_Additional_Data(\StructType\Edit_Position_Restrictions_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Edit_Position_Restrictions_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Edit_Job_Requisition_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Allows updating of effective-dated custom objects for job requisitions. When updating custom objects that allow multiple instances, data for existing instances must appear in the request, otherwise it will be removed.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Edit_Job_Requisition_Additional_Data_RequestType $body
     * @return \StructType\Edit_Job_Requisition_Additional_Data_ResponseType|bool
     */
    public function Edit_Job_Requisition_Additional_Data(\StructType\Edit_Job_Requisition_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Edit_Job_Requisition_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Edit_Evergreen_Requisition_ResponseType|\StructType\Edit_Job_Requisition_Additional_Data_ResponseType|\StructType\Edit_Job_Requisition_ResponseType|\StructType\Edit_Position_Restrictions_Additional_Data_ResponseType|\StructType\Edit_Positon_Restriction_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
