<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assess ServiceType
 * @subpackage Services
 */
class Assess extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Assess_Candidate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates or modifies a candidate's assessment and moves the candidate to the next stage that you specify in the main Job Application business process. The Job Application business process relevant to the candidate must be in the
     * Assess Candidate stage. You can use this operation only with outbound integrations to deliver candidate information to external vendors. You can't use it with inbound integrations to trigger the next step in a Job Application Event business
     * process.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Assess_Candidate_RequestType $body
     * @return \StructType\Assess_Candidate_ResponseType|bool
     */
    public function Assess_Candidate(\StructType\Assess_Candidate_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Assess_Candidate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Assess_Candidate_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
