<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSPerson StructType
 * @subpackage Structs
 */
class WSPerson extends AbstractStructBase
{
    /**
     * The bcrID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $bcrID;
    /**
     * The cardID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $cardID;
    /**
     * The driverKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $driverKey;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $employee;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $firstname;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The lastLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lastLogin;
    /**
     * The lastname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lastname;
    /**
     * The moduleBDE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $moduleBDE;
    /**
     * The moduleFZE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $moduleFZE;
    /**
     * The modulePZE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $modulePZE;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The personID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $personID;
    /**
     * The requirePwdChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $requirePwdChange;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $user;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The validUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $validUntil;
    /**
     * Constructor method for WSPerson
     * @uses WSPerson::setBcrID()
     * @uses WSPerson::setCardID()
     * @uses WSPerson::setDriverKey()
     * @uses WSPerson::setEmployee()
     * @uses WSPerson::setFirstname()
     * @uses WSPerson::setId()
     * @uses WSPerson::setLastLogin()
     * @uses WSPerson::setLastname()
     * @uses WSPerson::setModuleBDE()
     * @uses WSPerson::setModuleFZE()
     * @uses WSPerson::setModulePZE()
     * @uses WSPerson::setPassword()
     * @uses WSPerson::setPersonID()
     * @uses WSPerson::setRequirePwdChange()
     * @uses WSPerson::setUser()
     * @uses WSPerson::setUsername()
     * @uses WSPerson::setValidUntil()
     * @param int $bcrID
     * @param int $cardID
     * @param string $driverKey
     * @param bool $employee
     * @param string $firstname
     * @param int $id
     * @param int $lastLogin
     * @param string $lastname
     * @param bool $moduleBDE
     * @param bool $moduleFZE
     * @param bool $modulePZE
     * @param string $password
     * @param string $personID
     * @param bool $requirePwdChange
     * @param bool $user
     * @param string $username
     * @param int $validUntil
     */
    public function __construct($bcrID = null, $cardID = null, $driverKey = null, $employee = null, $firstname = null, $id = null, $lastLogin = null, $lastname = null, $moduleBDE = null, $moduleFZE = null, $modulePZE = null, $password = null, $personID = null, $requirePwdChange = null, $user = null, $username = null, $validUntil = null)
    {
        $this
            ->setBcrID($bcrID)
            ->setCardID($cardID)
            ->setDriverKey($driverKey)
            ->setEmployee($employee)
            ->setFirstname($firstname)
            ->setId($id)
            ->setLastLogin($lastLogin)
            ->setLastname($lastname)
            ->setModuleBDE($moduleBDE)
            ->setModuleFZE($moduleFZE)
            ->setModulePZE($modulePZE)
            ->setPassword($password)
            ->setPersonID($personID)
            ->setRequirePwdChange($requirePwdChange)
            ->setUser($user)
            ->setUsername($username)
            ->setValidUntil($validUntil);
    }
    /**
     * Get bcrID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBcrID()
    {
        return isset($this->bcrID) ? $this->bcrID : null;
    }
    /**
     * Set bcrID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bcrID
     * @return \StructType\WSPerson
     */
    public function setBcrID($bcrID = null)
    {
        // validation for constraint: int
        if (!is_null($bcrID) && !(is_int($bcrID) || ctype_digit($bcrID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bcrID, true), gettype($bcrID)), __LINE__);
        }
        if (is_null($bcrID) || (is_array($bcrID) && empty($bcrID))) {
            unset($this->bcrID);
        } else {
            $this->bcrID = $bcrID;
        }
        return $this;
    }
    /**
     * Get cardID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCardID()
    {
        return isset($this->cardID) ? $this->cardID : null;
    }
    /**
     * Set cardID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cardID
     * @return \StructType\WSPerson
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        if (is_null($cardID) || (is_array($cardID) && empty($cardID))) {
            unset($this->cardID);
        } else {
            $this->cardID = $cardID;
        }
        return $this;
    }
    /**
     * Get driverKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDriverKey()
    {
        return isset($this->driverKey) ? $this->driverKey : null;
    }
    /**
     * Set driverKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $driverKey
     * @return \StructType\WSPerson
     */
    public function setDriverKey($driverKey = null)
    {
        // validation for constraint: string
        if (!is_null($driverKey) && !is_string($driverKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverKey, true), gettype($driverKey)), __LINE__);
        }
        if (is_null($driverKey) || (is_array($driverKey) && empty($driverKey))) {
            unset($this->driverKey);
        } else {
            $this->driverKey = $driverKey;
        }
        return $this;
    }
    /**
     * Get employee value
     * @return bool|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param bool $employee
     * @return \StructType\WSPerson
     */
    public function setEmployee($employee = null)
    {
        // validation for constraint: boolean
        if (!is_null($employee) && !is_bool($employee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($employee, true), gettype($employee)), __LINE__);
        }
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get firstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstname()
    {
        return isset($this->firstname) ? $this->firstname : null;
    }
    /**
     * Set firstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstname
     * @return \StructType\WSPerson
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        if (is_null($firstname) || (is_array($firstname) && empty($firstname))) {
            unset($this->firstname);
        } else {
            $this->firstname = $firstname;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSPerson
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get lastLogin value
     * @return int|null
     */
    public function getLastLogin()
    {
        return $this->lastLogin;
    }
    /**
     * Set lastLogin value
     * @param int $lastLogin
     * @return \StructType\WSPerson
     */
    public function setLastLogin($lastLogin = null)
    {
        // validation for constraint: int
        if (!is_null($lastLogin) && !(is_int($lastLogin) || ctype_digit($lastLogin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastLogin, true), gettype($lastLogin)), __LINE__);
        }
        $this->lastLogin = $lastLogin;
        return $this;
    }
    /**
     * Get lastname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastname()
    {
        return isset($this->lastname) ? $this->lastname : null;
    }
    /**
     * Set lastname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastname
     * @return \StructType\WSPerson
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        if (is_null($lastname) || (is_array($lastname) && empty($lastname))) {
            unset($this->lastname);
        } else {
            $this->lastname = $lastname;
        }
        return $this;
    }
    /**
     * Get moduleBDE value
     * @return bool|null
     */
    public function getModuleBDE()
    {
        return $this->moduleBDE;
    }
    /**
     * Set moduleBDE value
     * @param bool $moduleBDE
     * @return \StructType\WSPerson
     */
    public function setModuleBDE($moduleBDE = null)
    {
        // validation for constraint: boolean
        if (!is_null($moduleBDE) && !is_bool($moduleBDE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moduleBDE, true), gettype($moduleBDE)), __LINE__);
        }
        $this->moduleBDE = $moduleBDE;
        return $this;
    }
    /**
     * Get moduleFZE value
     * @return bool|null
     */
    public function getModuleFZE()
    {
        return $this->moduleFZE;
    }
    /**
     * Set moduleFZE value
     * @param bool $moduleFZE
     * @return \StructType\WSPerson
     */
    public function setModuleFZE($moduleFZE = null)
    {
        // validation for constraint: boolean
        if (!is_null($moduleFZE) && !is_bool($moduleFZE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moduleFZE, true), gettype($moduleFZE)), __LINE__);
        }
        $this->moduleFZE = $moduleFZE;
        return $this;
    }
    /**
     * Get modulePZE value
     * @return bool|null
     */
    public function getModulePZE()
    {
        return $this->modulePZE;
    }
    /**
     * Set modulePZE value
     * @param bool $modulePZE
     * @return \StructType\WSPerson
     */
    public function setModulePZE($modulePZE = null)
    {
        // validation for constraint: boolean
        if (!is_null($modulePZE) && !is_bool($modulePZE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modulePZE, true), gettype($modulePZE)), __LINE__);
        }
        $this->modulePZE = $modulePZE;
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\WSPerson
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get personID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonID()
    {
        return isset($this->personID) ? $this->personID : null;
    }
    /**
     * Set personID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personID
     * @return \StructType\WSPerson
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: string
        if (!is_null($personID) && !is_string($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        if (is_null($personID) || (is_array($personID) && empty($personID))) {
            unset($this->personID);
        } else {
            $this->personID = $personID;
        }
        return $this;
    }
    /**
     * Get requirePwdChange value
     * @return bool|null
     */
    public function getRequirePwdChange()
    {
        return $this->requirePwdChange;
    }
    /**
     * Set requirePwdChange value
     * @param bool $requirePwdChange
     * @return \StructType\WSPerson
     */
    public function setRequirePwdChange($requirePwdChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($requirePwdChange) && !is_bool($requirePwdChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requirePwdChange, true), gettype($requirePwdChange)), __LINE__);
        }
        $this->requirePwdChange = $requirePwdChange;
        return $this;
    }
    /**
     * Get user value
     * @return bool|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param bool $user
     * @return \StructType\WSPerson
     */
    public function setUser($user = null)
    {
        // validation for constraint: boolean
        if (!is_null($user) && !is_bool($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\WSPerson
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get validUntil value
     * @return int|null
     */
    public function getValidUntil()
    {
        return $this->validUntil;
    }
    /**
     * Set validUntil value
     * @param int $validUntil
     * @return \StructType\WSPerson
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: int
        if (!is_null($validUntil) && !(is_int($validUntil) || ctype_digit($validUntil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        $this->validUntil = $validUntil;
        return $this;
    }
}
