<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryDoorExceptionBlock StructType
 * @subpackage Structs
 */
class WSEntryDoorExceptionBlock extends AbstractStructBase
{
    /**
     * The doorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doorId;
    /**
     * The exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSEntryException
     */
    public $exceptions;
    /**
     * Constructor method for WSEntryDoorExceptionBlock
     * @uses WSEntryDoorExceptionBlock::setDoorId()
     * @uses WSEntryDoorExceptionBlock::setExceptions()
     * @param int $doorId
     * @param \ArrayType\ArrayOfWSEntryException $exceptions
     */
    public function __construct($doorId = null, \ArrayType\ArrayOfWSEntryException $exceptions = null)
    {
        $this
            ->setDoorId($doorId)
            ->setExceptions($exceptions);
    }
    /**
     * Get doorId value
     * @return int|null
     */
    public function getDoorId()
    {
        return $this->doorId;
    }
    /**
     * Set doorId value
     * @param int $doorId
     * @return \StructType\WSEntryDoorExceptionBlock
     */
    public function setDoorId($doorId = null)
    {
        // validation for constraint: int
        if (!is_null($doorId) && !(is_int($doorId) || ctype_digit($doorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doorId, true), gettype($doorId)), __LINE__);
        }
        $this->doorId = $doorId;
        return $this;
    }
    /**
     * Get exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSEntryException|null
     */
    public function getExceptions()
    {
        return isset($this->exceptions) ? $this->exceptions : null;
    }
    /**
     * Set exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSEntryException $exceptions
     * @return \StructType\WSEntryDoorExceptionBlock
     */
    public function setExceptions(\ArrayType\ArrayOfWSEntryException $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->exceptions);
        } else {
            $this->exceptions = $exceptions;
        }
        return $this;
    }
}
