<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importTerminalBookings2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportTerminalBookings2 $parameters
     * @return \StructType\ImportTerminalBookings2Response|bool
     */
    public function importTerminalBookings2(\StructType\ImportTerminalBookings2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importTerminalBookings2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importBarcodeData2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportBarcodeData2 $parameters
     * @return \StructType\ImportBarcodeData2Response|bool
     */
    public function importBarcodeData2(\StructType\ImportBarcodeData2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importBarcodeData2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importBarcodeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportBarcodeData $parameters
     * @return \StructType\ImportBarcodeDataResponse|bool
     */
    public function importBarcodeData(\StructType\ImportBarcodeData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importBarcodeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importTerminalBookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportTerminalBookings $parameters
     * @return \StructType\ImportTerminalBookingsResponse|bool
     */
    public function importTerminalBookings(\StructType\ImportTerminalBookings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importTerminalBookings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportBarcodeData2Response|\StructType\ImportBarcodeDataResponse|\StructType\ImportTerminalBookings2Response|\StructType\ImportTerminalBookingsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
