<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSLink ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSLink extends AbstractStructArrayBase
{
    /**
     * The WSLink
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink[]
     */
    public $WSLink;
    /**
     * Constructor method for ArrayOfWSLink
     * @uses ArrayOfWSLink::setWSLink()
     * @param \StructType\WSLink[] $wSLink
     */
    public function __construct(array $wSLink = array())
    {
        $this
            ->setWSLink($wSLink);
    }
    /**
     * Get WSLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink[]|null
     */
    public function getWSLink()
    {
        return isset($this->WSLink) ? $this->WSLink : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSLinkForArrayConstraintsFromSetWSLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSLinkWSLinkItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSLinkWSLinkItem instanceof \StructType\WSLink) {
                $invalidValues[] = is_object($arrayOfWSLinkWSLinkItem) ? get_class($arrayOfWSLinkWSLinkItem) : sprintf('%s(%s)', gettype($arrayOfWSLinkWSLinkItem), var_export($arrayOfWSLinkWSLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSLink property can only contain items of type \StructType\WSLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSLink[] $wSLink
     * @return \ArrayType\ArrayOfWSLink
     */
    public function setWSLink(array $wSLink = array())
    {
        // validation for constraint: array
        if ('' !== ($wSLinkArrayErrorMessage = self::validateWSLinkForArrayConstraintsFromSetWSLink($wSLink))) {
            throw new \InvalidArgumentException($wSLinkArrayErrorMessage, __LINE__);
        }
        if (is_null($wSLink) || (is_array($wSLink) && empty($wSLink))) {
            unset($this->WSLink);
        } else {
            $this->WSLink = $wSLink;
        }
        return $this;
    }
    /**
     * Add item to WSLink value
     * @throws \InvalidArgumentException
     * @param \StructType\WSLink $item
     * @return \ArrayType\ArrayOfWSLink
     */
    public function addToWSLink(\StructType\WSLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSLink) {
            throw new \InvalidArgumentException(sprintf('The WSLink property can only contain items of type \StructType\WSLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSLink[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSLink|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSLink|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSLink|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSLink|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSLink|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSLink
     */
    public function getAttributeName()
    {
        return 'WSLink';
    }
}
