<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named modifyGroupMemberships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyGroupMemberships $parameters
     * @return \StructType\ModifyGroupMembershipsResponse|bool
     */
    public function modifyGroupMemberships(\StructType\ModifyGroupMemberships $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyGroupMemberships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyTasks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyTasks $parameters
     * @return \StructType\ModifyTasksResponse|bool
     */
    public function modifyTasks(\StructType\ModifyTasks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyTasks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyTrip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyTrip $parameters
     * @return \StructType\ModifyTripResponse|bool
     */
    public function modifyTrip(\StructType\ModifyTrip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyTrip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyTrips
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyTrips $parameters
     * @return \StructType\ModifyTripsResponse|bool
     */
    public function modifyTrips(\StructType\ModifyTrips $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyTrips($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyEntryDoors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyEntryDoors $parameters
     * @return \StructType\ModifyEntryDoorsResponse|bool
     */
    public function modifyEntryDoors(\StructType\ModifyEntryDoors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyEntryDoors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyLevels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyLevels $parameters
     * @return \StructType\ModifyLevelsResponse|bool
     */
    public function modifyLevels(\StructType\ModifyLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyEntryTerminals
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyEntryTerminals $parameters
     * @return \StructType\ModifyEntryTerminalsResponse|bool
     */
    public function modifyEntryTerminals(\StructType\ModifyEntryTerminals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->modifyEntryTerminals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ModifyEntryDoorsResponse|\StructType\ModifyEntryTerminalsResponse|\StructType\ModifyGroupMembershipsResponse|\StructType\ModifyLevelsResponse|\StructType\ModifyTasksResponse|\StructType\ModifyTripResponse|\StructType\ModifyTripsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
