<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSCustomTerminalInfoBlock ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSCustomTerminalInfoBlock extends AbstractStructArrayBase
{
    /**
     * The WSCustomTerminalInfoBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSCustomTerminalInfoBlock[]
     */
    public $WSCustomTerminalInfoBlock;
    /**
     * Constructor method for ArrayOfWSCustomTerminalInfoBlock
     * @uses ArrayOfWSCustomTerminalInfoBlock::setWSCustomTerminalInfoBlock()
     * @param \StructType\WSCustomTerminalInfoBlock[] $wSCustomTerminalInfoBlock
     */
    public function __construct(array $wSCustomTerminalInfoBlock = array())
    {
        $this
            ->setWSCustomTerminalInfoBlock($wSCustomTerminalInfoBlock);
    }
    /**
     * Get WSCustomTerminalInfoBlock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSCustomTerminalInfoBlock[]|null
     */
    public function getWSCustomTerminalInfoBlock()
    {
        return isset($this->WSCustomTerminalInfoBlock) ? $this->WSCustomTerminalInfoBlock : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSCustomTerminalInfoBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSCustomTerminalInfoBlock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSCustomTerminalInfoBlockForArrayConstraintsFromSetWSCustomTerminalInfoBlock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSCustomTerminalInfoBlockWSCustomTerminalInfoBlockItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSCustomTerminalInfoBlockWSCustomTerminalInfoBlockItem instanceof \StructType\WSCustomTerminalInfoBlock) {
                $invalidValues[] = is_object($arrayOfWSCustomTerminalInfoBlockWSCustomTerminalInfoBlockItem) ? get_class($arrayOfWSCustomTerminalInfoBlockWSCustomTerminalInfoBlockItem) : sprintf('%s(%s)', gettype($arrayOfWSCustomTerminalInfoBlockWSCustomTerminalInfoBlockItem), var_export($arrayOfWSCustomTerminalInfoBlockWSCustomTerminalInfoBlockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSCustomTerminalInfoBlock property can only contain items of type \StructType\WSCustomTerminalInfoBlock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSCustomTerminalInfoBlock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomTerminalInfoBlock[] $wSCustomTerminalInfoBlock
     * @return \ArrayType\ArrayOfWSCustomTerminalInfoBlock
     */
    public function setWSCustomTerminalInfoBlock(array $wSCustomTerminalInfoBlock = array())
    {
        // validation for constraint: array
        if ('' !== ($wSCustomTerminalInfoBlockArrayErrorMessage = self::validateWSCustomTerminalInfoBlockForArrayConstraintsFromSetWSCustomTerminalInfoBlock($wSCustomTerminalInfoBlock))) {
            throw new \InvalidArgumentException($wSCustomTerminalInfoBlockArrayErrorMessage, __LINE__);
        }
        if (is_null($wSCustomTerminalInfoBlock) || (is_array($wSCustomTerminalInfoBlock) && empty($wSCustomTerminalInfoBlock))) {
            unset($this->WSCustomTerminalInfoBlock);
        } else {
            $this->WSCustomTerminalInfoBlock = $wSCustomTerminalInfoBlock;
        }
        return $this;
    }
    /**
     * Add item to WSCustomTerminalInfoBlock value
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomTerminalInfoBlock $item
     * @return \ArrayType\ArrayOfWSCustomTerminalInfoBlock
     */
    public function addToWSCustomTerminalInfoBlock(\StructType\WSCustomTerminalInfoBlock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSCustomTerminalInfoBlock) {
            throw new \InvalidArgumentException(sprintf('The WSCustomTerminalInfoBlock property can only contain items of type \StructType\WSCustomTerminalInfoBlock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSCustomTerminalInfoBlock[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSCustomTerminalInfoBlock|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSCustomTerminalInfoBlock|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSCustomTerminalInfoBlock|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSCustomTerminalInfoBlock|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSCustomTerminalInfoBlock|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSCustomTerminalInfoBlock
     */
    public function getAttributeName()
    {
        return 'WSCustomTerminalInfoBlock';
    }
}
