<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSLevelModification StructType
 * @subpackage Structs
 */
class WSLevelModification extends AbstractStructBase
{
    /**
     * The levelCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $levelCode;
    /**
     * The levelDBId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $levelDBId;
    /**
     * The levelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $levelId;
    /**
     * The modifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSModification
     */
    public $modifications;
    /**
     * Constructor method for WSLevelModification
     * @uses WSLevelModification::setLevelCode()
     * @uses WSLevelModification::setLevelDBId()
     * @uses WSLevelModification::setLevelId()
     * @uses WSLevelModification::setModifications()
     * @param string $levelCode
     * @param int $levelDBId
     * @param int $levelId
     * @param \ArrayType\ArrayOfWSModification $modifications
     */
    public function __construct($levelCode = null, $levelDBId = null, $levelId = null, \ArrayType\ArrayOfWSModification $modifications = null)
    {
        $this
            ->setLevelCode($levelCode)
            ->setLevelDBId($levelDBId)
            ->setLevelId($levelId)
            ->setModifications($modifications);
    }
    /**
     * Get levelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevelCode()
    {
        return isset($this->levelCode) ? $this->levelCode : null;
    }
    /**
     * Set levelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $levelCode
     * @return \StructType\WSLevelModification
     */
    public function setLevelCode($levelCode = null)
    {
        // validation for constraint: string
        if (!is_null($levelCode) && !is_string($levelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($levelCode, true), gettype($levelCode)), __LINE__);
        }
        if (is_null($levelCode) || (is_array($levelCode) && empty($levelCode))) {
            unset($this->levelCode);
        } else {
            $this->levelCode = $levelCode;
        }
        return $this;
    }
    /**
     * Get levelDBId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLevelDBId()
    {
        return isset($this->levelDBId) ? $this->levelDBId : null;
    }
    /**
     * Set levelDBId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $levelDBId
     * @return \StructType\WSLevelModification
     */
    public function setLevelDBId($levelDBId = null)
    {
        // validation for constraint: int
        if (!is_null($levelDBId) && !(is_int($levelDBId) || ctype_digit($levelDBId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($levelDBId, true), gettype($levelDBId)), __LINE__);
        }
        if (is_null($levelDBId) || (is_array($levelDBId) && empty($levelDBId))) {
            unset($this->levelDBId);
        } else {
            $this->levelDBId = $levelDBId;
        }
        return $this;
    }
    /**
     * Get levelId value
     * @return int|null
     */
    public function getLevelId()
    {
        return $this->levelId;
    }
    /**
     * Set levelId value
     * @param int $levelId
     * @return \StructType\WSLevelModification
     */
    public function setLevelId($levelId = null)
    {
        // validation for constraint: int
        if (!is_null($levelId) && !(is_int($levelId) || ctype_digit($levelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($levelId, true), gettype($levelId)), __LINE__);
        }
        $this->levelId = $levelId;
        return $this;
    }
    /**
     * Get modifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSModification|null
     */
    public function getModifications()
    {
        return isset($this->modifications) ? $this->modifications : null;
    }
    /**
     * Set modifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @return \StructType\WSLevelModification
     */
    public function setModifications(\ArrayType\ArrayOfWSModification $modifications = null)
    {
        if (is_null($modifications) || (is_array($modifications) && empty($modifications))) {
            unset($this->modifications);
        } else {
            $this->modifications = $modifications;
        }
        return $this;
    }
}
