<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSKeyValueGroup StructType
 * @subpackage Structs
 */
class WSKeyValueGroup extends AbstractStructBase
{
    /**
     * The entries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $entries;
    /**
     * The subgroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValueGroup
     */
    public $subgroups;
    /**
     * Constructor method for WSKeyValueGroup
     * @uses WSKeyValueGroup::setEntries()
     * @uses WSKeyValueGroup::setSubgroups()
     * @param \ArrayType\ArrayOfWSKeyValue $entries
     * @param \ArrayType\ArrayOfWSKeyValueGroup $subgroups
     */
    public function __construct(\ArrayType\ArrayOfWSKeyValue $entries = null, \ArrayType\ArrayOfWSKeyValueGroup $subgroups = null)
    {
        $this
            ->setEntries($entries)
            ->setSubgroups($subgroups);
    }
    /**
     * Get entries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getEntries()
    {
        return isset($this->entries) ? $this->entries : null;
    }
    /**
     * Set entries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $entries
     * @return \StructType\WSKeyValueGroup
     */
    public function setEntries(\ArrayType\ArrayOfWSKeyValue $entries = null)
    {
        if (is_null($entries) || (is_array($entries) && empty($entries))) {
            unset($this->entries);
        } else {
            $this->entries = $entries;
        }
        return $this;
    }
    /**
     * Get subgroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValueGroup|null
     */
    public function getSubgroups()
    {
        return isset($this->subgroups) ? $this->subgroups : null;
    }
    /**
     * Set subgroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValueGroup $subgroups
     * @return \StructType\WSKeyValueGroup
     */
    public function setSubgroups(\ArrayType\ArrayOfWSKeyValueGroup $subgroups = null)
    {
        if (is_null($subgroups) || (is_array($subgroups) && empty($subgroups))) {
            unset($this->subgroups);
        } else {
            $this->subgroups = $subgroups;
        }
        return $this;
    }
}
