<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSBookingPair StructType
 * @subpackage Structs
 */
class WSBookingPair extends AbstractStructBase
{
    /**
     * The absence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $absence;
    /**
     * The checked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $checked;
    /**
     * The complete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $complete;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $from;
    /**
     * The fromBookingID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $fromBookingID;
    /**
     * The fullDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fullDay;
    /**
     * The levels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSLevelIdentification
     */
    public $levels;
    /**
     * The notice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $notice;
    /**
     * The person
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $person;
    /**
     * The properties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSProperty
     */
    public $properties;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $to;
    /**
     * The toBookingID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $toBookingID;
    /**
     * Constructor method for WSBookingPair
     * @uses WSBookingPair::setAbsence()
     * @uses WSBookingPair::setChecked()
     * @uses WSBookingPair::setComplete()
     * @uses WSBookingPair::setDuration()
     * @uses WSBookingPair::setFrom()
     * @uses WSBookingPair::setFromBookingID()
     * @uses WSBookingPair::setFullDay()
     * @uses WSBookingPair::setLevels()
     * @uses WSBookingPair::setNotice()
     * @uses WSBookingPair::setPerson()
     * @uses WSBookingPair::setProperties()
     * @uses WSBookingPair::setTo()
     * @uses WSBookingPair::setToBookingID()
     * @param bool $absence
     * @param bool $checked
     * @param bool $complete
     * @param int $duration
     * @param \StructType\WSTimestamp $from
     * @param int $fromBookingID
     * @param bool $fullDay
     * @param \ArrayType\ArrayOfWSLevelIdentification $levels
     * @param string $notice
     * @param string $person
     * @param \ArrayType\ArrayOfWSProperty $properties
     * @param \StructType\WSTimestamp $to
     * @param int $toBookingID
     */
    public function __construct($absence = null, $checked = null, $complete = null, $duration = null, \StructType\WSTimestamp $from = null, $fromBookingID = null, $fullDay = null, \ArrayType\ArrayOfWSLevelIdentification $levels = null, $notice = null, $person = null, \ArrayType\ArrayOfWSProperty $properties = null, \StructType\WSTimestamp $to = null, $toBookingID = null)
    {
        $this
            ->setAbsence($absence)
            ->setChecked($checked)
            ->setComplete($complete)
            ->setDuration($duration)
            ->setFrom($from)
            ->setFromBookingID($fromBookingID)
            ->setFullDay($fullDay)
            ->setLevels($levels)
            ->setNotice($notice)
            ->setPerson($person)
            ->setProperties($properties)
            ->setTo($to)
            ->setToBookingID($toBookingID);
    }
    /**
     * Get absence value
     * @return bool|null
     */
    public function getAbsence()
    {
        return $this->absence;
    }
    /**
     * Set absence value
     * @param bool $absence
     * @return \StructType\WSBookingPair
     */
    public function setAbsence($absence = null)
    {
        // validation for constraint: boolean
        if (!is_null($absence) && !is_bool($absence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($absence, true), gettype($absence)), __LINE__);
        }
        $this->absence = $absence;
        return $this;
    }
    /**
     * Get checked value
     * @return bool|null
     */
    public function getChecked()
    {
        return $this->checked;
    }
    /**
     * Set checked value
     * @param bool $checked
     * @return \StructType\WSBookingPair
     */
    public function setChecked($checked = null)
    {
        // validation for constraint: boolean
        if (!is_null($checked) && !is_bool($checked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checked, true), gettype($checked)), __LINE__);
        }
        $this->checked = $checked;
        return $this;
    }
    /**
     * Get complete value
     * @return bool|null
     */
    public function getComplete()
    {
        return $this->complete;
    }
    /**
     * Set complete value
     * @param bool $complete
     * @return \StructType\WSBookingPair
     */
    public function setComplete($complete = null)
    {
        // validation for constraint: boolean
        if (!is_null($complete) && !is_bool($complete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($complete, true), gettype($complete)), __LINE__);
        }
        $this->complete = $complete;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\WSBookingPair
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getFrom()
    {
        return isset($this->from) ? $this->from : null;
    }
    /**
     * Set from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $from
     * @return \StructType\WSBookingPair
     */
    public function setFrom(\StructType\WSTimestamp $from = null)
    {
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->from);
        } else {
            $this->from = $from;
        }
        return $this;
    }
    /**
     * Get fromBookingID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromBookingID()
    {
        return isset($this->fromBookingID) ? $this->fromBookingID : null;
    }
    /**
     * Set fromBookingID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromBookingID
     * @return \StructType\WSBookingPair
     */
    public function setFromBookingID($fromBookingID = null)
    {
        // validation for constraint: int
        if (!is_null($fromBookingID) && !(is_int($fromBookingID) || ctype_digit($fromBookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromBookingID, true), gettype($fromBookingID)), __LINE__);
        }
        if (is_null($fromBookingID) || (is_array($fromBookingID) && empty($fromBookingID))) {
            unset($this->fromBookingID);
        } else {
            $this->fromBookingID = $fromBookingID;
        }
        return $this;
    }
    /**
     * Get fullDay value
     * @return bool|null
     */
    public function getFullDay()
    {
        return $this->fullDay;
    }
    /**
     * Set fullDay value
     * @param bool $fullDay
     * @return \StructType\WSBookingPair
     */
    public function setFullDay($fullDay = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullDay) && !is_bool($fullDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullDay, true), gettype($fullDay)), __LINE__);
        }
        $this->fullDay = $fullDay;
        return $this;
    }
    /**
     * Get levels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSLevelIdentification|null
     */
    public function getLevels()
    {
        return isset($this->levels) ? $this->levels : null;
    }
    /**
     * Set levels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSLevelIdentification $levels
     * @return \StructType\WSBookingPair
     */
    public function setLevels(\ArrayType\ArrayOfWSLevelIdentification $levels = null)
    {
        if (is_null($levels) || (is_array($levels) && empty($levels))) {
            unset($this->levels);
        } else {
            $this->levels = $levels;
        }
        return $this;
    }
    /**
     * Get notice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotice()
    {
        return isset($this->notice) ? $this->notice : null;
    }
    /**
     * Set notice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notice
     * @return \StructType\WSBookingPair
     */
    public function setNotice($notice = null)
    {
        // validation for constraint: string
        if (!is_null($notice) && !is_string($notice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notice, true), gettype($notice)), __LINE__);
        }
        if (is_null($notice) || (is_array($notice) && empty($notice))) {
            unset($this->notice);
        } else {
            $this->notice = $notice;
        }
        return $this;
    }
    /**
     * Get person value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerson()
    {
        return isset($this->person) ? $this->person : null;
    }
    /**
     * Set person value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $person
     * @return \StructType\WSBookingPair
     */
    public function setPerson($person = null)
    {
        // validation for constraint: string
        if (!is_null($person) && !is_string($person)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person, true), gettype($person)), __LINE__);
        }
        if (is_null($person) || (is_array($person) && empty($person))) {
            unset($this->person);
        } else {
            $this->person = $person;
        }
        return $this;
    }
    /**
     * Get properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSProperty|null
     */
    public function getProperties()
    {
        return isset($this->properties) ? $this->properties : null;
    }
    /**
     * Set properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSProperty $properties
     * @return \StructType\WSBookingPair
     */
    public function setProperties(\ArrayType\ArrayOfWSProperty $properties = null)
    {
        if (is_null($properties) || (is_array($properties) && empty($properties))) {
            unset($this->properties);
        } else {
            $this->properties = $properties;
        }
        return $this;
    }
    /**
     * Get to value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTo()
    {
        return isset($this->to) ? $this->to : null;
    }
    /**
     * Set to value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $to
     * @return \StructType\WSBookingPair
     */
    public function setTo(\StructType\WSTimestamp $to = null)
    {
        if (is_null($to) || (is_array($to) && empty($to))) {
            unset($this->to);
        } else {
            $this->to = $to;
        }
        return $this;
    }
    /**
     * Get toBookingID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToBookingID()
    {
        return isset($this->toBookingID) ? $this->toBookingID : null;
    }
    /**
     * Set toBookingID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toBookingID
     * @return \StructType\WSBookingPair
     */
    public function setToBookingID($toBookingID = null)
    {
        // validation for constraint: int
        if (!is_null($toBookingID) && !(is_int($toBookingID) || ctype_digit($toBookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toBookingID, true), gettype($toBookingID)), __LINE__);
        }
        if (is_null($toBookingID) || (is_array($toBookingID) && empty($toBookingID))) {
            unset($this->toBookingID);
        } else {
            $this->toBookingID = $toBookingID;
        }
        return $this;
    }
}
