<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findPersonsByTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPersonsByTerminal $parameters
     * @return \StructType\FindPersonsByTerminalResponse|bool
     */
    public function findPersonsByTerminal(\StructType\FindPersonsByTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPersonsByTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findAccountDefinitionsByTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAccountDefinitionsByTerminal $parameters
     * @return \StructType\FindAccountDefinitionsByTerminalResponse|bool
     */
    public function findAccountDefinitionsByTerminal(\StructType\FindAccountDefinitionsByTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findAccountDefinitionsByTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPropertiesByLevelDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPropertiesByLevelDBID $parameters
     * @return \StructType\FindPropertiesByLevelDBIDResponse|bool
     */
    public function findPropertiesByLevelDBID(\StructType\FindPropertiesByLevelDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPropertiesByLevelDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findCustomerLinksByLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomerLinksByLocation $parameters
     * @return \StructType\FindCustomerLinksByLocationResponse|bool
     */
    public function findCustomerLinksByLocation(\StructType\FindCustomerLinksByLocation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCustomerLinksByLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPersonsByKeyValueE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPersonsByKeyValueE $parameters
     * @return \StructType\FindPersonsByKeyValueEResponse|bool
     */
    public function findPersonsByKeyValueE(\StructType\FindPersonsByKeyValueE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPersonsByKeyValueE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findTripsByPersonDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindTripsByPersonDBID $parameters
     * @return \StructType\FindTripsByPersonDBIDResponse|bool
     */
    public function findTripsByPersonDBID(\StructType\FindTripsByPersonDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findTripsByPersonDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findTrips2ByWSLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindTrips2ByWSLink $parameters
     * @return \StructType\FindTrips2ByWSLinkResponse|bool
     */
    public function findTrips2ByWSLink(\StructType\FindTrips2ByWSLink $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findTrips2ByWSLink($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPropertiesByVehicleDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPropertiesByVehicleDBID $parameters
     * @return \StructType\FindPropertiesByVehicleDBIDResponse|bool
     */
    public function findPropertiesByVehicleDBID(\StructType\FindPropertiesByVehicleDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPropertiesByVehicleDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findLevelsEByCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindLevelsEByCustomer $parameters
     * @return \StructType\FindLevelsEByCustomerResponse|bool
     */
    public function findLevelsEByCustomer(\StructType\FindLevelsEByCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findLevelsEByCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findCustomerByReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomerByReference $parameters
     * @return \StructType\FindCustomerByReferenceResponse|bool
     */
    public function findCustomerByReference(\StructType\FindCustomerByReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCustomerByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPersonsByTerminalNr
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPersonsByTerminalNr $parameters
     * @return \StructType\FindPersonsByTerminalNrResponse|bool
     */
    public function findPersonsByTerminalNr(\StructType\FindPersonsByTerminalNr $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPersonsByTerminalNr($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findTripsByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindTripsByPersonID $parameters
     * @return \StructType\FindTripsByPersonIDResponse|bool
     */
    public function findTripsByPersonID(\StructType\FindTripsByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findTripsByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findVehicleInBounds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindVehicleInBounds $parameters
     * @return \StructType\FindVehicleInBoundsResponse|bool
     */
    public function findVehicleInBounds(\StructType\FindVehicleInBounds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findVehicleInBounds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findChanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindChanges $parameters
     * @return \StructType\FindChangesResponse|bool
     */
    public function findChanges(\StructType\FindChanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPropertiesByLinkTypeAndDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPropertiesByLinkTypeAndDBID $parameters
     * @return \StructType\FindPropertiesByLinkTypeAndDBIDResponse|bool
     */
    public function findPropertiesByLinkTypeAndDBID(\StructType\FindPropertiesByLinkTypeAndDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPropertiesByLinkTypeAndDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findCustomersEByReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomersEByReference $parameters
     * @return \StructType\FindCustomersEByReferenceResponse|bool
     */
    public function findCustomersEByReference(\StructType\FindCustomersEByReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCustomersEByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPropertiesByPersonDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPropertiesByPersonDBID $parameters
     * @return \StructType\FindPropertiesByPersonDBIDResponse|bool
     */
    public function findPropertiesByPersonDBID(\StructType\FindPropertiesByPersonDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPropertiesByPersonDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findCustomersByReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomersByReference $parameters
     * @return \StructType\FindCustomersByReferenceResponse|bool
     */
    public function findCustomersByReference(\StructType\FindCustomersByReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCustomersByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPersonsByTerminalE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPersonsByTerminalE $parameters
     * @return \StructType\FindPersonsByTerminalEResponse|bool
     */
    public function findPersonsByTerminalE(\StructType\FindPersonsByTerminalE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPersonsByTerminalE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findAccountDefinitionssByTerminalNr
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAccountDefinitionssByTerminalNr $parameters
     * @return \StructType\FindAccountDefinitionssByTerminalNrResponse|bool
     */
    public function findAccountDefinitionssByTerminalNr(\StructType\FindAccountDefinitionssByTerminalNr $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findAccountDefinitionssByTerminalNr($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findCustomersEByLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomersEByLocation $parameters
     * @return \StructType\FindCustomersEByLocationResponse|bool
     */
    public function findCustomersEByLocation(\StructType\FindCustomersEByLocation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCustomersEByLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindAccountDefinitionsByTerminalResponse|\StructType\FindAccountDefinitionssByTerminalNrResponse|\StructType\FindChangesResponse|\StructType\FindCustomerByReferenceResponse|\StructType\FindCustomerLinksByLocationResponse|\StructType\FindCustomersByReferenceResponse|\StructType\FindCustomersEByLocationResponse|\StructType\FindCustomersEByReferenceResponse|\StructType\FindLevelsEByCustomerResponse|\StructType\FindPersonsByKeyValueEResponse|\StructType\FindPersonsByTerminalEResponse|\StructType\FindPersonsByTerminalNrResponse|\StructType\FindPersonsByTerminalResponse|\StructType\FindPropertiesByLevelDBIDResponse|\StructType\FindPropertiesByLinkTypeAndDBIDResponse|\StructType\FindPropertiesByPersonDBIDResponse|\StructType\FindPropertiesByVehicleDBIDResponse|\StructType\FindTrips2ByWSLinkResponse|\StructType\FindTripsByPersonDBIDResponse|\StructType\FindTripsByPersonIDResponse|\StructType\FindVehicleInBoundsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
