<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSLinkedDuration StructType
 * @subpackage Structs
 */
class WSLinkedDuration extends AbstractStructBase
{
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $flags;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $from;
    /**
     * The link
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $link;
    /**
     * The secondaryLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $secondaryLink;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $to;
    /**
     * Constructor method for WSLinkedDuration
     * @uses WSLinkedDuration::setDuration()
     * @uses WSLinkedDuration::setFlags()
     * @uses WSLinkedDuration::setFrom()
     * @uses WSLinkedDuration::setLink()
     * @uses WSLinkedDuration::setSecondaryLink()
     * @uses WSLinkedDuration::setTo()
     * @param int $duration
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @param \StructType\WSTimestamp $from
     * @param \StructType\WSLink $link
     * @param \StructType\WSLink $secondaryLink
     * @param \StructType\WSTimestamp $to
     */
    public function __construct($duration = null, \ArrayType\ArrayOfWSKeyValue $flags = null, \StructType\WSTimestamp $from = null, \StructType\WSLink $link = null, \StructType\WSLink $secondaryLink = null, \StructType\WSTimestamp $to = null)
    {
        $this
            ->setDuration($duration)
            ->setFlags($flags)
            ->setFrom($from)
            ->setLink($link)
            ->setSecondaryLink($secondaryLink)
            ->setTo($to);
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\WSLinkedDuration
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @return \StructType\WSLinkedDuration
     */
    public function setFlags(\ArrayType\ArrayOfWSKeyValue $flags = null)
    {
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
    /**
     * Get from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getFrom()
    {
        return isset($this->from) ? $this->from : null;
    }
    /**
     * Set from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $from
     * @return \StructType\WSLinkedDuration
     */
    public function setFrom(\StructType\WSTimestamp $from = null)
    {
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->from);
        } else {
            $this->from = $from;
        }
        return $this;
    }
    /**
     * Get link value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getLink()
    {
        return isset($this->link) ? $this->link : null;
    }
    /**
     * Set link value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $link
     * @return \StructType\WSLinkedDuration
     */
    public function setLink(\StructType\WSLink $link = null)
    {
        if (is_null($link) || (is_array($link) && empty($link))) {
            unset($this->link);
        } else {
            $this->link = $link;
        }
        return $this;
    }
    /**
     * Get secondaryLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getSecondaryLink()
    {
        return isset($this->secondaryLink) ? $this->secondaryLink : null;
    }
    /**
     * Set secondaryLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $secondaryLink
     * @return \StructType\WSLinkedDuration
     */
    public function setSecondaryLink(\StructType\WSLink $secondaryLink = null)
    {
        if (is_null($secondaryLink) || (is_array($secondaryLink) && empty($secondaryLink))) {
            unset($this->secondaryLink);
        } else {
            $this->secondaryLink = $secondaryLink;
        }
        return $this;
    }
    /**
     * Get to value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTo()
    {
        return isset($this->to) ? $this->to : null;
    }
    /**
     * Set to value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $to
     * @return \StructType\WSLinkedDuration
     */
    public function setTo(\StructType\WSTimestamp $to = null)
    {
        if (is_null($to) || (is_array($to) && empty($to))) {
            unset($this->to);
        } else {
            $this->to = $to;
        }
        return $this;
    }
}
