<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryExceptionDay StructType
 * @subpackage Structs
 */
class WSEntryExceptionDay extends AbstractStructBase
{
    /**
     * The day
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $day;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $flags;
    /**
     * The month
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $month;
    /**
     * The timeBands
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSEntryPeriodTimeBand
     */
    public $timeBands;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $year;
    /**
     * Constructor method for WSEntryExceptionDay
     * @uses WSEntryExceptionDay::setDay()
     * @uses WSEntryExceptionDay::setFlags()
     * @uses WSEntryExceptionDay::setMonth()
     * @uses WSEntryExceptionDay::setTimeBands()
     * @uses WSEntryExceptionDay::setYear()
     * @param int $day
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @param int $month
     * @param \ArrayType\ArrayOfWSEntryPeriodTimeBand $timeBands
     * @param int $year
     */
    public function __construct($day = null, \ArrayType\ArrayOfWSKeyValue $flags = null, $month = null, \ArrayType\ArrayOfWSEntryPeriodTimeBand $timeBands = null, $year = null)
    {
        $this
            ->setDay($day)
            ->setFlags($flags)
            ->setMonth($month)
            ->setTimeBands($timeBands)
            ->setYear($year);
    }
    /**
     * Get day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \StructType\WSEntryExceptionDay
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @return \StructType\WSEntryExceptionDay
     */
    public function setFlags(\ArrayType\ArrayOfWSKeyValue $flags = null)
    {
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
    /**
     * Get month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @param int $month
     * @return \StructType\WSEntryExceptionDay
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Get timeBands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSEntryPeriodTimeBand|null
     */
    public function getTimeBands()
    {
        return isset($this->timeBands) ? $this->timeBands : null;
    }
    /**
     * Set timeBands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSEntryPeriodTimeBand $timeBands
     * @return \StructType\WSEntryExceptionDay
     */
    public function setTimeBands(\ArrayType\ArrayOfWSEntryPeriodTimeBand $timeBands = null)
    {
        if (is_null($timeBands) || (is_array($timeBands) && empty($timeBands))) {
            unset($this->timeBands);
        } else {
            $this->timeBands = $timeBands;
        }
        return $this;
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\WSEntryExceptionDay
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
}
