<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteFullDayBookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteFullDayBookings $parameters
     * @return \StructType\DeleteFullDayBookingsResponse|bool
     */
    public function deleteFullDayBookings(\StructType\DeleteFullDayBookings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteFullDayBookings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteTask
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteTask $parameters
     * @return \StructType\DeleteTaskResponse|bool
     */
    public function deleteTask(\StructType\DeleteTask $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteTask($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteBookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteBookings $parameters
     * @return \StructType\DeleteBookingsResponse|bool
     */
    public function deleteBookings(\StructType\DeleteBookings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteBookings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteCustomersByDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomersByDBID $parameters
     * @return \StructType\DeleteCustomersByDBIDResponse|bool
     */
    public function deleteCustomersByDBID(\StructType\DeleteCustomersByDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteCustomersByDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteCustomersByReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomersByReference $parameters
     * @return \StructType\DeleteCustomersByReferenceResponse|bool
     */
    public function deleteCustomersByReference(\StructType\DeleteCustomersByReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteCustomersByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteGroup $parameters
     * @return \StructType\DeleteGroupResponse|bool
     */
    public function deleteGroup(\StructType\DeleteGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAttachedDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAttachedDocuments $parameters
     * @return \StructType\DeleteAttachedDocumentsResponse|bool
     */
    public function deleteAttachedDocuments(\StructType\DeleteAttachedDocuments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteAttachedDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteAttachedDocumentsResponse|\StructType\DeleteBookingsResponse|\StructType\DeleteCustomersByDBIDResponse|\StructType\DeleteCustomersByReferenceResponse|\StructType\DeleteFullDayBookingsResponse|\StructType\DeleteGroupResponse|\StructType\DeleteTaskResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
